/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.util;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class LTKWorkbenchUIUtil {
    /*
     * WARNING - void declaration
     */
    public static AbstractDocument getDocument(IWorkbenchPart part) {
        SourceEditor editor = (SourceEditor)part.getAdapter(SourceEditor.class);
        if (editor != null) {
            return (AbstractDocument)editor.getViewer().getDocument();
        }
        IWorkbenchPart iWorkbenchPart = part;
        if (iWorkbenchPart instanceof AbstractTextEditor) {
            void textEditor;
            editor = (AbstractTextEditor)iWorkbenchPart;
            AbstractTextEditor cfr_ignored_0 = (AbstractTextEditor)iWorkbenchPart;
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            if (documentProvider != null) {
                return (AbstractDocument)documentProvider.getDocument((Object)textEditor.getEditorInput());
            }
        }
        return null;
    }

    public static String getContentTypeId(IWorkbenchPart part) {
        IContentType contentType = (IContentType)part.getAdapter(IContentType.class);
        if (contentType != null) {
            return contentType.getId();
        }
        if (part instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)part).getEditorInput();
            IFile file = ResourceUtil.getFile((IEditorInput)input);
            if (file != null) {
                IContentType contentType2 = IDE.guessContentType((IFile)file);
                return contentType2 != null ? contentType2.getId() : null;
            }
            String fileName = null;
            if (input instanceof IPathEditorInput) {
                fileName = ((IPathEditorInput)input).getPath().lastSegment();
            } else if (input instanceof IURIEditorInput) {
                fileName = URIUtil.lastSegment((URI)((IURIEditorInput)input).getURI());
            }
            if (fileName != null) {
                IContentType contentType3 = Platform.getContentTypeManager().findContentTypeFor(fileName);
                return contentType3 != null ? contentType3.getId() : null;
            }
        }
        return null;
    }

    public static @Nullable IFile getFile(@Nullable IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    public static void openEditor(final IWorkbenchPage page, final IFile file, final @Nullable IRegion initialSelection) {
        Display display = page.getWorkbenchWindow().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                block16: {
                    IMarker marker = null;
                    if (initialSelection != null) {
                        try {
                            marker = file.createMarker("org.eclipse.statet.ltk.resourceMarkers.InitialSelection", Map.of("charStart", initialSelection.getOffset(), "charEnd", initialSelection.getOffset() + initialSelection.getLength()));
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    try {
                        try {
                            if (marker != null) {
                                IDE.openEditor((IWorkbenchPage)page, marker, (boolean)true);
                                break block16;
                            }
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                        }
                        catch (PartInitException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", -1, NLS.bind((String)"Could not open editor for ''{0}''", (Object)file.getName()), (Throwable)e));
                            if (marker == null) break block16;
                            try {
                                marker.delete();
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                    finally {
                        if (marker != null) {
                            try {
                                marker.delete();
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                }
            }
        });
    }

    public static void indicateStatus(IStatus status, ExecutionEvent executionEvent) {
        IEditorStatusLine statusLine;
        IWorkbenchPart workbenchPart;
        if (status.isOK()) {
            return;
        }
        if (status.getMessage() != null && executionEvent != null && (workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)executionEvent)) != null && (statusLine = (IEditorStatusLine)workbenchPart.getAdapter(IEditorStatusLine.class)) != null) {
            statusLine.setMessage(status.getSeverity() == 4, status.getMessage(), null);
        }
        if (status.getSeverity() == 4) {
            Display.getCurrent().beep();
        }
    }

    private LTKWorkbenchUIUtil() {
    }
}

