/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.workbench.search.ui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.statet.ecommons.workbench.search.ui.ElementMatchComparator;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.SortedArraySet;
import org.eclipse.statet.jcommons.collections.SortedListSet;

public abstract class ExtTextSearchResult<E, M extends Match>
extends AbstractTextSearchResult {
    private final ElementMatchComparator<E, M> comparator;
    private final SortedListSet<E> elementList;
    private final Map<E, SortedListSet<M>> elementMatches;
    private final CopyOnWriteIdentityListSet<ISearchResultListener> listeners = new CopyOnWriteIdentityListSet();
    private final ChangeEvent changeEvent = new ChangeEvent((ISearchResult)this);

    public ExtTextSearchResult(ElementMatchComparator<E, M> comparator) {
        this.comparator = comparator;
        this.elementList = new SortedArraySet((Object[])comparator.getElement0(), comparator.getElementComparator());
        this.elementMatches = new HashMap<E, SortedListSet<M>>();
    }

    public ElementMatchComparator<E, M> getComparator() {
        return this.comparator;
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return null;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return null;
    }

    public void addListener(ISearchResultListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ISearchResultListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected ChangeEvent getChangeEvent(int eventKind, Match match) {
        this.changeEvent.setKind(eventKind);
        this.changeEvent.setMatch(match);
        return this.changeEvent;
    }

    protected ChangeEvent getChangeEvent(int eventKind, List<Match> matches) {
        this.changeEvent.setKind(eventKind);
        this.changeEvent.setMatches(matches.toArray(new Match[matches.size()]));
        return this.changeEvent;
    }

    protected void fireChange(SearchResultEvent e) {
        for (ISearchResultListener listener : this.listeners) {
            listener.searchResultChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getElementCount() {
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            return this.elementList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E[] getElements() {
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            return this.elementList.toArray((Object[])this.comparator.getElement0());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addMatch(Match match) {
        boolean done;
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            done = this.doAddMatch(match);
        }
        if (done) {
            this.fireChange((SearchResultEvent)this.getChangeEvent(1, match));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addMatches(Match[] matches) {
        ArrayList<Match> added = new ArrayList<Match>(matches.length);
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            int i = 0;
            while (i < matches.length) {
                if (this.doAddMatch(matches[i])) {
                    added.add(matches[i]);
                }
                ++i;
            }
        }
        if (!added.isEmpty()) {
            this.fireChange((SearchResultEvent)this.getChangeEvent(1, added));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAddMatch(M match) {
        Object element = match.getElement();
        if (element == null) {
            return false;
        }
        SortedArraySet matches = this.elementMatches.get(element);
        if (matches == null) {
            if (this.elementList.addE(element) < 0) {
                return false;
            }
            matches = new SortedArraySet((Object[])this.comparator.getMatch0(), this.comparator.getMatchComparator());
            this.elementMatches.put((E)element, (SortedListSet<M>)matches);
        }
        SortedArraySet sortedArraySet = matches;
        synchronized (sortedArraySet) {
            block7: {
                if (matches.addE(match) < 0) break block7;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeMatch(Match match) {
        boolean done;
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            done = this.doRemoveMatch(match);
        }
        if (done) {
            this.fireChange((SearchResultEvent)this.getChangeEvent(2, match));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeMatches(Match[] matches) {
        ArrayList<Match> removed = new ArrayList<Match>(matches.length);
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            int i = 0;
            while (i < matches.length) {
                if (this.doRemoveMatch(matches[i])) {
                    removed.add(matches[i]);
                }
                ++i;
            }
        }
        if (!removed.isEmpty()) {
            this.fireChange((SearchResultEvent)this.getChangeEvent(2, removed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doRemoveMatch(M match) {
        Object element = match.getElement();
        if (element == null) {
            return false;
        }
        SortedListSet<M> matches = this.elementMatches.get(element);
        if (matches == null) {
            return false;
        }
        SortedListSet<M> sortedListSet = matches;
        synchronized (sortedListSet) {
            if (matches.removeE(match) < 0) {
                return false;
            }
        }
        if (matches.isEmpty()) {
            this.elementList.remove(element);
            this.elementMatches.remove(element);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAll() {
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            this.doRemoveAll();
        }
        this.fireChange((SearchResultEvent)new RemoveAllEvent((ISearchResult)this));
    }

    protected void doRemoveAll() {
        this.elementList.clear();
        this.elementMatches.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMatchCount() {
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            int count = 0;
            for (List list : this.elementMatches.values()) {
                count += list.size();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMatches(Object element) {
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            return this.elementMatches.containsKey(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasPickedMatches(Object element) {
        SortedListSet<M> matches;
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            matches = this.elementMatches.get(element);
        }
        if (matches == null) return false;
        if (this.getActiveMatchFilters() == null) {
            return true;
        }
        map = matches;
        synchronized (map) {
            Match match;
            Iterator iterator = matches.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((match = (Match)iterator.next()).isFiltered());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMatchCount(Object element) {
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            SortedListSet<M> matches = this.elementMatches.get(element);
            if (matches != null) {
                return matches.size();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPickedMatchCount(Object element) {
        SortedListSet<M> matches;
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            matches = this.elementMatches.get(element);
        }
        if (matches != null) {
            if (this.getActiveMatchFilters() == null) {
                map = matches;
                synchronized (map) {
                    return matches.size();
                }
            }
            map = matches;
            synchronized (map) {
                int count = 0;
                for (Match match : matches) {
                    if (match.isFiltered()) continue;
                    ++count;
                }
                return count;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public M[] getMatches(Object element) {
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            SortedListSet<M> matches = this.elementMatches.get(element);
            if (matches != null) {
                return (Match[])matches.toArray((Object[])this.comparator.getMatch0());
            }
            return this.comparator.getMatch0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public M[] getPickedMatches(Object element) {
        SortedListSet<M> matches;
        Map<E, SortedListSet<M>> map = this.elementMatches;
        synchronized (map) {
            matches = this.elementMatches.get(element);
        }
        if (matches != null) {
            if (this.getActiveMatchFilters() == null) {
                map = matches;
                synchronized (map) {
                    return (Match[])matches.toArray((Object[])this.comparator.getMatch0());
                }
            }
            map = matches;
            synchronized (map) {
                ArrayList<Match> filtered = new ArrayList<Match>(matches.size());
                for (Match match : matches) {
                    if (match.isFiltered()) continue;
                    filtered.add(match);
                }
                return filtered.toArray(this.comparator.getMatch0());
            }
        }
        return this.comparator.getMatch0();
    }

    private static class ChangeEvent
    extends MatchEvent {
        private static final long serialVersionUID = -5266244762347509979L;

        public ChangeEvent(ISearchResult searchResult) {
            super(searchResult);
        }

        protected void setKind(int kind) {
            super.setKind(kind);
        }

        protected void setMatch(Match match) {
            super.setMatch(match);
        }

        protected void setMatches(Match[] matches) {
            super.setMatches(matches);
        }
    }

    protected static class DefaultMatchComparator<M extends Match>
    implements Comparator<M> {
        @Override
        public int compare(M o1, M o2) {
            int d = o1.getOffset() - o2.getOffset();
            if (d != 0) {
                return d;
            }
            return o1.getLength() - o2.getLength();
        }
    }
}

