/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.coordinate;

import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NonNullByDefault
public enum Direction {
    LEFT{

        @Override
        public Orientation getOrientation() {
            return Orientation.HORIZONTAL;
        }

        @Override
        public boolean isForward() {
            return false;
        }

        @Override
        public boolean isBackward() {
            return true;
        }

        @Override
        public Direction getOpposite() {
            return RIGHT;
        }
    }
    ,
    RIGHT{

        @Override
        public Orientation getOrientation() {
            return Orientation.HORIZONTAL;
        }

        @Override
        public boolean isForward() {
            return true;
        }

        @Override
        public boolean isBackward() {
            return false;
        }

        @Override
        public Direction getOpposite() {
            return LEFT;
        }
    }
    ,
    UP{

        @Override
        public Orientation getOrientation() {
            return Orientation.VERTICAL;
        }

        @Override
        public boolean isForward() {
            return false;
        }

        @Override
        public boolean isBackward() {
            return true;
        }

        @Override
        public Direction getOpposite() {
            return DOWN;
        }
    }
    ,
    DOWN{

        @Override
        public Orientation getOrientation() {
            return Orientation.VERTICAL;
        }

        @Override
        public boolean isForward() {
            return true;
        }

        @Override
        public boolean isBackward() {
            return false;
        }

        @Override
        public Direction getOpposite() {
            return UP;
        }
    };


    public static Direction forward(Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return RIGHT;
            }
            case VERTICAL: {
                return LEFT;
            }
        }
        throw new IllegalStateException();
    }

    public static Direction backward(Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return LEFT;
            }
            case VERTICAL: {
                return UP;
            }
        }
        throw new IllegalStateException();
    }

    public abstract Orientation getOrientation();

    public abstract boolean isForward();

    public abstract boolean isBackward();

    public abstract Direction getOpposite();
}

