/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.core.util;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ecommons.debug.core.Messages;
import org.eclipse.statet.jcommons.collections.CaseInsensitiveMap;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.ProcessUtils;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;

@NonNullByDefault
public class LaunchUtils {
    private static Pattern ENV_PATTERN = Pattern.compile("\\Q${env_var:\\E([^\\}]*)\\}");

    public static @Nullable ILaunchConfiguration findLaunchConfiguration(ILaunchConfiguration[] launchConfigurations, ILaunchConfigurationType type, String name) throws CoreException {
        int i = 0;
        while (i < launchConfigurations.length) {
            ILaunchConfiguration aConfig = launchConfigurations[i];
            if (aConfig.getType().equals(type) && aConfig.getName().equals(name)) {
                return aConfig;
            }
            ++i;
        }
        return null;
    }

    public static ILaunchConfigurationDelegate getLaunchConfigurationDelegate(ILaunchConfiguration configuration, String mode, MultiStatus status) throws CoreException {
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        if (mode == null) {
            throw new NullPointerException("mode");
        }
        ImSet modes = ImCollections.newSet((Object)mode);
        ILaunchDelegate launchDelegate = configuration.getPreferredDelegate((Set)modes);
        if (launchDelegate != null) {
            return launchDelegate.getDelegate();
        }
        ILaunchConfigurationType type = configuration.getType();
        launchDelegate = configuration.getType().getPreferredDelegate((Set)modes);
        if (launchDelegate != null) {
            return launchDelegate.getDelegate();
        }
        ILaunchDelegate[] delegates = type.getDelegates((Set)modes);
        if (delegates.length > 0) {
            if (status != null && delegates.length > 1) {
                status.add((IStatus)new Status(2, "org.eclipse.statet.ecommons.debug.core", NLS.bind((String)"Multiple launchers available but no set as preferred for {0} ({1}).", (Object)type.getName(), (Object)LaunchUtils.getModeLabel(mode))));
            }
            return delegates[0].getDelegate();
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.core", NLS.bind((String)"No launcher available for {0} ({1}).", (Object)type.getName(), (Object)LaunchUtils.getModeLabel(mode))));
    }

    private static String getModeLabel(String mode) {
        try {
            return DebugPlugin.getDefault().getLaunchManager().getLaunchMode(mode).getLabel();
        }
        catch (Exception e) {
            return String.valueOf('<') + mode + '>';
        }
    }

    public static void configureEnvironment(Map<String, String> env, ILaunchConfiguration configuration, Map<String, String> add) throws CoreException {
        env.clear();
        env.putAll(LaunchUtils.createEnvironment(configuration, add));
    }

    @SafeVarargs
    public static Map<String, String> createEnvironment(ILaunchConfiguration configuration, Map<String, String> ... additionals) throws CoreException {
        Map custom;
        Object envp;
        Object object = envp = Platform.getOS().startsWith("win") ? new CaseInsensitiveMap(64) : new HashMap(64);
        if (configuration == null || configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true)) {
            envp.putAll(DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved());
        }
        Map map = custom = configuration != null ? configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null) : null;
        if (additionals != null) {
            Map<String, String>[] mapArray = additionals;
            int n = additionals.length;
            int n2 = 0;
            while (n2 < n) {
                Map<String, String> additional = mapArray[n2];
                if (additional != null) {
                    envp.putAll(LaunchUtils.check((Map<String, String>)envp, additional));
                } else if (custom != null) {
                    envp.putAll(LaunchUtils.check((Map<String, String>)envp, custom));
                    custom = null;
                }
                ++n2;
            }
        }
        if (custom != null) {
            envp.putAll(LaunchUtils.check((Map<String, String>)envp, custom));
            custom = null;
        }
        return envp;
    }

    private static Map<String, String> check(Map<String, String> current, Map<String, String> add) throws CoreException {
        HashMap<String, String> resolved = new HashMap<String, String>();
        Set<Map.Entry<String, String>> entries = add.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String value = entry.getValue();
            if (value != null && !value.isEmpty()) {
                if (value.contains("${env_var:")) {
                    StringBuffer sb = new StringBuffer(value.length() + 32);
                    Matcher matcher = ENV_PATTERN.matcher(value);
                    while (matcher.find()) {
                        String var = matcher.group(1);
                        String varValue = current.get(var);
                        matcher.appendReplacement(sb, varValue != null ? Matcher.quoteReplacement(varValue) : "");
                    }
                    matcher.appendTail(sb);
                    value = sb.toString();
                }
                if (value.contains("${")) {
                    value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value, true);
                }
            }
            resolved.put(entry.getKey(), value);
        }
        return resolved;
    }

    public static String[] getProcessArguments(ILaunchConfiguration configuration, String attr) throws CoreException {
        String args = configuration.getAttribute(attr, "");
        String expanded = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
        return DebugPlugin.parseArguments((String)expanded);
    }

    @Deprecated
    public static String generateCommandLine(List<String> commandLine) {
        return ProcessUtils.generateCommandLine(commandLine);
    }

    public static @NonNull String[] toKeyValueStrings(Map<String, String> map) {
        String[] array = new String[map.size()];
        Iterator<Map.Entry<String, String>> iter = map.entrySet().iterator();
        int i = 0;
        while (i < array.length) {
            Map.Entry<String, String> entry = iter.next();
            array[i] = String.valueOf(entry.getKey()) + '=' + entry.getValue();
            ++i;
        }
        return array;
    }

    public static String createProcessTimestamp(long time) {
        return "(" + DateFormat.getDateTimeInstance().format(new Date(time)) + ")";
    }

    public static String createLaunchPrefix(@Nullable ILaunchConfiguration config) {
        StringBuilder s = new StringBuilder();
        if (config != null) {
            String type = null;
            try {
                type = config.getType().getName();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            s.append(config.getName());
            if (type != null) {
                s.append(" [");
                s.append(type);
                s.append("]");
            }
        } else {
            s.append("[-]");
        }
        return s.toString();
    }

    public static SubMonitor initProgressMonitor(ILaunchConfiguration configuration, @Nullable IProgressMonitor monitor, int taskTotalWork) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LaunchDelegate_LaunchingTask_label, (int)taskTotalWork);
        progress.subTask(Messages.LaunchDelegate_Init_subtask);
        return progress;
    }

    public static ProgressMonitor initProgressMonitorS(ILaunchConfiguration configuration, IProgressMonitor monitor, int taskTotalWork) {
        ProgressMonitor m = EStatusUtils.convert((IProgressMonitor)monitor, (String)Messages.LaunchDelegate_LaunchingTask_label, (int)taskTotalWork);
        m.beginSubTask(Messages.LaunchDelegate_Init_subtask);
        return m;
    }

    private LaunchUtils() {
    }
}

