/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.platform.operations.ILabeledWorkspaceRunnable;
import org.eclipse.sphinx.platform.operations.IWorkspaceOperation;
import org.eclipse.sphinx.platform.operations.WorkspaceOperationAdapter;
import org.eclipse.sphinx.platform.ui.internal.messages.Messages;

public class RunnableWithProgressAdapter
implements IRunnableWithProgress {
    private IWorkspaceRunnable operation;

    public RunnableWithProgressAdapter(IWorkspaceRunnable operation) {
        Assert.isNotNull((Object)operation);
        this.operation = operation;
    }

    public RunnableWithProgressAdapter(ILabeledWorkspaceRunnable operation) {
        Assert.isNotNull((Object)operation);
        this.operation = operation;
    }

    public RunnableWithProgressAdapter(IWorkspaceOperation operation) {
        Assert.isNotNull((Object)operation);
        this.operation = operation;
    }

    public RunnableWithProgressAdapter(String label, ISchedulingRule rule, IWorkspaceRunnable operation) {
        this((IWorkspaceOperation)new WorkspaceOperationAdapter(label, rule, operation));
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            ISchedulingRule rule = this.operation instanceof IWorkspaceOperation ? ((IWorkspaceOperation)this.operation).getRule() : null;
            ResourcesPlugin.getWorkspace().run(this.operation, rule, 1, monitor);
        }
        catch (CoreException ex) {
            String msg = this.operation instanceof ILabeledWorkspaceRunnable ? NLS.bind((String)Messages.error_whileRunningOperation, (Object)((ILabeledWorkspaceRunnable)this.operation).getLabel()) : NLS.bind((String)Messages.error_whileRunningOperation, (Object)this.operation.getClass().getSimpleName());
            throw new InvocationTargetException(ex, msg);
        }
        catch (OperationCanceledException ex) {
            throw new InterruptedException(ex.getMessage());
        }
    }
}

