/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.platform.operations.IWorkspaceOperation;
import org.eclipse.sphinx.platform.operations.WorkspaceOperationAdapter;
import org.eclipse.sphinx.platform.ui.internal.messages.Messages;

public class RunnableWithProgressAdapter
implements IRunnableWithProgress {
    private IWorkspaceOperation operation;

    public RunnableWithProgressAdapter(String label, ISchedulingRule rule, IWorkspaceRunnable runnable) {
        this((IWorkspaceOperation)new WorkspaceOperationAdapter(label, rule, runnable));
    }

    public RunnableWithProgressAdapter(IWorkspaceOperation operation) {
        Assert.isNotNull((Object)operation);
        this.operation = operation;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)this.operation, this.operation.getRule(), 0, monitor);
        }
        catch (CoreException ex) {
            throw new InvocationTargetException(ex, NLS.bind((String)Messages.error_whileRunningOperation, (Object)this.operation.getLabel()));
        }
        catch (OperationCanceledException ex) {
            throw new InterruptedException(ex.getMessage());
        }
    }
}

