/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.internal.util;

import org.eclipse.sphinx.platform.ui.internal.util.PixelConverter;
import org.eclipse.sphinx.platform.ui.util.SWTUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LayoutUtil {
    protected static final int MAX_WITDH = 175;

    public static void setWidthHint(Control control, int widthHint) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).widthHint = widthHint;
        }
    }

    public static void setHorizontalGrabbing(Control control) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).grabExcessHorizontalSpace = true;
        }
    }

    public static void setHorizontalSpan(Control control, int span) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalSpan = span;
        } else if (span != 1) {
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            control.setLayoutData((Object)gd);
        }
    }

    public static final GridData gridDataForCombo(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    public static final TableWrapData tableWrapDataForCombo(int span) {
        TableWrapData twd = new TableWrapData();
        twd.align = 128;
        twd.grabHorizontal = false;
        twd.colspan = span;
        return twd;
    }

    public static final GridData gridDataForCCombo(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = span;
        return gd;
    }

    public static final TableWrapData tableWrapDataForCCombo(int span) {
        TableWrapData twd = new TableWrapData(128, 32);
        twd.grabHorizontal = true;
        twd.colspan = span;
        twd.maxWidth = 175;
        return twd;
    }

    public static final GridData gridDataForButtons(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = span;
        return gd;
    }

    public static final TableWrapData tableWrapDataForButtons(int span) {
        TableWrapData twd = new TableWrapData();
        twd.align = 128;
        twd.grabHorizontal = false;
        twd.valign = 128;
        twd.grabVertical = true;
        twd.colspan = span;
        return twd;
    }

    public static final GridData gridDataForButton(Button button, int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        if ((button.getStyle() & 8) != 0) {
            gd.widthHint = SWTUtil.getButtonWidthHint(button);
        }
        return gd;
    }

    public static final TableWrapData tableWrapDataForButton(Button button, int span) {
        TableWrapData twd = new TableWrapData();
        twd.align = 128;
        twd.grabHorizontal = false;
        twd.colspan = span;
        if ((button.getStyle() & 8) != 0) {
            twd.maxWidth = SWTUtil.getButtonWidthHint(button);
        }
        return twd;
    }

    public static final GridData gridDataForLabel(int span) {
        return LayoutUtil.gridDataForLabel(span, false);
    }

    public static final GridData gridDataForLabel(int span, boolean multiLine) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        gd.verticalAlignment = multiLine ? 1 : 2;
        return gd;
    }

    public static final TableWrapData tableWrapDataForLabel(int span) {
        return LayoutUtil.tableWrapDataForLabel(span, false);
    }

    public static final TableWrapData tableWrapDataForLabel(int span, boolean multiLine) {
        TableWrapData twd = new TableWrapData();
        twd.colspan = span;
        twd.valign = multiLine ? 16 : 32;
        return twd;
    }

    public static final GridData gridDataForList(int span, PixelConverter converter) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = span;
        gd.widthHint = converter.convertWidthInCharsToPixels(50);
        gd.heightHint = converter.convertHeightInCharsToPixels(6);
        return gd;
    }

    public static final TableWrapData tableWrapDataForList(int span, PixelConverter converter) {
        TableWrapData twd = new TableWrapData();
        twd.align = 128;
        twd.grabHorizontal = true;
        twd.valign = 128;
        twd.grabVertical = true;
        twd.colspan = span;
        twd.maxWidth = converter.convertWidthInCharsToPixels(50);
        twd.heightHint = converter.convertHeightInCharsToPixels(6);
        return twd;
    }

    public static final GridData gridDataForText(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = span;
        return gd;
    }

    public static final TableWrapData tableWrapDataForText(int span) {
        TableWrapData twd = new TableWrapData(256);
        twd.colspan = span;
        twd.valign = 32;
        return twd;
    }

    public static final GridData gridDataForSeperator(int span, int height) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = height;
        gd.horizontalSpan = span;
        return gd;
    }

    public static final GridData gridDataForSpecificComposite(int span) {
        return LayoutUtil.gridDataForSpecificComposite(span, true, true);
    }

    public static final GridData gridDataForSpecificComposite(int span, boolean hgrab, boolean vgrab) {
        GridData gd = new GridData(4, 4, hgrab, vgrab);
        gd.horizontalSpan = span;
        return gd;
    }

    public static final GridLayout gridLayoutForSpecificComposite(int numColumns) {
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = numColumns;
        return gl;
    }

    public static final TableWrapData tableWrapDataForSpecificComposite(int span) {
        return LayoutUtil.tableWrapDataForSpecificComposite(span, true, true);
    }

    public static final TableWrapData tableWrapDataForSpecificComposite(int span, boolean hgrab, boolean vgrab) {
        TableWrapData twd = new TableWrapData(256);
        twd.colspan = span;
        twd.grabHorizontal = hgrab;
        twd.grabVertical = vgrab;
        return twd;
    }

    public static final TableWrapLayout tableWrapLayoutForSpecificComposite(int numColumns) {
        TableWrapLayout twl = new TableWrapLayout();
        twl.topMargin = 0;
        twl.bottomMargin = 0;
        twl.leftMargin = 0;
        twl.rightMargin = 0;
        twl.numColumns = numColumns;
        return twl;
    }
}

