/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.edit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.sphinx.emf.edit.ITreeItemAncestorProvider;

public class TreeItemAncestorProvider
implements ITreeItemAncestorProvider {
    protected ITreeItemContentProvider contentProvider;
    protected AdapterFactory adapterFactory;
    protected ResourceItemProviderAdapterFactory resourceItemProviderAdapterFactory = null;

    public TreeItemAncestorProvider(Object contentProvider, AdapterFactory adapterFactory) {
        Assert.isNotNull((Object)adapterFactory);
        if (contentProvider instanceof ITreeItemContentProvider) {
            this.contentProvider = (ITreeItemContentProvider)contentProvider;
        }
        this.adapterFactory = adapterFactory;
    }

    @Override
    public List<Object> getAncestorPath(Object object, boolean unwrap) {
        return this.getAncestorPath(object, null, unwrap);
    }

    @Override
    public List<Object> getAncestorPath(Object beginObject, Class<?> endType, boolean unwrap) {
        if (beginObject != null) {
            ArrayList<Object> ancestorPath = new ArrayList<Object>();
            ancestorPath.add(unwrap ? this.unwrap(beginObject) : beginObject);
            Object parent = this.getContentProvider().getParent(beginObject);
            if (parent != null) {
                ancestorPath.add(unwrap ? this.unwrap(parent) : parent);
            }
            while (!(endType != null && endType.isInstance(this.unwrap(parent)) || parent == null)) {
                ITreeItemContentProvider parentContentProvider = (parent instanceof Resource || parent instanceof ResourceSet) && !(this.adapterFactory instanceof ResourceItemProviderAdapterFactory) ? (ITreeItemContentProvider)this.getResourceItemProviderAdapterFactory().adapt(parent, ITreeItemContentProvider.class) : (ITreeItemContentProvider)this.adapterFactory.adapt(parent, ITreeItemContentProvider.class);
                if ((parent = parentContentProvider.getParent(parent)) == null) continue;
                ancestorPath.add(unwrap ? this.unwrap(parent) : parent);
            }
            return ancestorPath;
        }
        return Collections.emptyList();
    }

    @Override
    public Object findAncestor(Object object, Class<?> ancestorType, boolean unwrap) {
        List<Object> ancestorPath = this.getAncestorPath(object, ancestorType, unwrap);
        if (!ancestorPath.isEmpty()) {
            Object ancestorObject = ancestorPath.get(ancestorPath.size() - 1);
            if (ancestorType == null || ancestorType.isInstance(this.unwrap(ancestorObject))) {
                return ancestorObject;
            }
        }
        return null;
    }

    protected Object unwrap(Object object) {
        return AdapterFactoryEditingDomain.unwrap((Object)object);
    }

    protected ITreeItemContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new ReflectiveItemProvider(this.adapterFactory);
        }
        return this.contentProvider;
    }

    protected ResourceItemProviderAdapterFactory getResourceItemProviderAdapterFactory() {
        if (this.resourceItemProviderAdapterFactory == null) {
            this.resourceItemProviderAdapterFactory = new ResourceItemProviderAdapterFactory();
        }
        return this.resourceItemProviderAdapterFactory;
    }
}

