/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.editors.forms.sections;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.editors.forms.BasicTransactionalFormEditor;
import org.eclipse.sphinx.emf.editors.forms.internal.messages.Messages;
import org.eclipse.sphinx.emf.editors.forms.pages.AbstractFormPage;
import org.eclipse.sphinx.emf.editors.forms.sections.AbstractViewerFormSection;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GenericContentsTreeSection
extends AbstractViewerFormSection {
    public GenericContentsTreeSection(AbstractFormPage formPage, Object sectionInput) {
        this(formPage, sectionInput, 0);
    }

    public GenericContentsTreeSection(AbstractFormPage formPage, Object sectionInput, int style) {
        super(formPage, sectionInput, style);
        this.description = Messages.section_genericContentsTree_description;
    }

    @Override
    public void setSectionInput(Object sectionInput) {
        super.setSectionInput(sectionInput);
        this.refreshSectionTitle();
    }

    protected Object getSectionInputParent() {
        IContentProvider contentProvider = this.getContentProvider();
        if (contentProvider instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)contentProvider).getParent(this.sectionInput);
        }
        return null;
    }

    @Override
    public Object getViewerInput() {
        if (!(this.sectionInput instanceof Resource)) {
            return this.getSectionInputParent();
        }
        return this.sectionInput;
    }

    @Override
    protected int getNumberOfColumns() {
        return 1;
    }

    @Override
    protected void createSectionClientContent(IManagedForm managedForm, SectionPart sectionPart, Composite sectionClient) {
        IBaseLabelProvider labelProvider;
        Assert.isNotNull((Object)managedForm);
        Assert.isNotNull((Object)sectionPart);
        Assert.isNotNull((Object)sectionClient);
        FormToolkit toolkit = managedForm.getToolkit();
        Tree tree = toolkit.createTree(sectionClient, 2818);
        tree.setLayoutData((Object)new GridData(1808));
        final BasicTransactionalFormEditor formEditor = this.formPage.getTransactionalFormEditor();
        TreeViewer treeViewer = new TreeViewer(tree){

            public void setSelection(ISelection selection) {
                selection = !SelectionUtil.getStructuredSelection((ISelection)selection).isEmpty() ? selection : formEditor.getDefaultSelection();
                super.setSelection(selection);
            }
        };
        this.viewer = treeViewer;
        IContentProvider contentProvider = this.getContentProvider();
        if (contentProvider != null) {
            treeViewer.setContentProvider(this.getContentProvider());
        }
        if ((labelProvider = this.getLabelProvider()) != null) {
            treeViewer.setLabelProvider(labelProvider);
        }
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return parentElement != GenericContentsTreeSection.this.getSectionInputParent() || element == GenericContentsTreeSection.this.sectionInput;
            }
        });
        treeViewer.setInput(this.getViewerInput());
        formEditor.createContextMenuFor((StructuredViewer)treeViewer);
    }

    @Override
    public void refreshSection() {
        this.refreshSectionTitle();
    }

    protected void refreshSectionTitle() {
        if (this.title == null && this.isControlAccessible((Control)this.section)) {
            this.section.setText(NLS.bind((String)Messages.section_genericContentsTree_title, (Object)this.getSectionInputName()));
        }
    }
}

