/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class Polyline
extends AbstractPointListShape {
    private int tolerance = 2;
    private final Rectangle LINEBOUNDS = Rectangle.getSINGLETON();

    public Polyline() {
        this.setFill(false);
        this.bounds = null;
    }

    public boolean containsPoint(int x, int y) {
        int tolerance = (int)Math.max(this.getLineWidthFloat() / 2.0f, (float)this.tolerance);
        this.LINEBOUNDS.setBounds(this.getBounds());
        this.LINEBOUNDS.expand(tolerance, tolerance);
        if (!this.LINEBOUNDS.contains(x, y)) {
            return false;
        }
        return this.shapeContainsPoint(x, y) || this.childrenContainsPoint(x, y);
    }

    protected boolean shapeContainsPoint(int x, int y) {
        return Geometry.polylineContainsPoint(this.points, x, y, this.tolerance);
    }

    protected void fillShape(Graphics g) {
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            int expand = (int)(this.getLineWidthFloat() / 2.0f);
            this.bounds = this.getPoints().getBounds().getExpanded(expand, expand);
        }
        return this.bounds;
    }

    public boolean isOpaque() {
        return false;
    }

    protected void outlineShape(Graphics g) {
        g.drawPolyline(this.points);
    }

    public void primTranslate(int x, int y) {
    }

    public void removeAllPoints() {
        super.removeAllPoints();
        this.bounds = null;
    }

    public void setLineWidth(int w) {
        if (this.getLineWidthFloat() == (float)w) {
            return;
        }
        if ((float)w < this.getLineWidthFloat()) {
            this.erase();
        }
        this.bounds = null;
        super.setLineWidthFloat(w);
    }

    public void setPoints(PointList points) {
        super.setPoints(points);
        this.firePropertyChange("points", null, points);
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    public void repaint() {
        this.bounds = null;
        super.repaint();
    }
}

