/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal;

import jakarta.servlet.ServletException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.rap.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.rap.http.servlet.internal.context.ServiceHolder;
import org.eclipse.rap.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.rap.http.servlet.internal.registration.PreprocessorRegistration;
import org.eclipse.rap.http.servlet.internal.servlet.FilterConfigImpl;
import org.eclipse.rap.http.servlet.internal.util.ServiceProperties;
import org.eclipse.rap.service.servlet.internal.runtime.dto.FailedPreprocessorDTO;
import org.eclipse.rap.service.servlet.internal.runtime.dto.PreprocessorDTO;
import org.eclipse.rap.service.servlet.internal.whiteboard.Preprocessor;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PreprocessorCustomizer
implements ServiceTrackerCustomizer<Preprocessor, AtomicReference<PreprocessorRegistration>> {
    private final HttpServiceRuntimeImpl httpServiceRuntime;

    public PreprocessorCustomizer(HttpServiceRuntimeImpl httpServiceRuntime) {
        this.httpServiceRuntime = httpServiceRuntime;
    }

    public AtomicReference<PreprocessorRegistration> addingService(ServiceReference<Preprocessor> serviceReference) {
        AtomicReference<PreprocessorRegistration> result = new AtomicReference<PreprocessorRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        try {
            try {
                this.removeFailed(serviceReference);
                result.set(this.addPreprocessorRegistration(serviceReference));
            }
            catch (HttpWhiteboardFailureException hwfe) {
                this.httpServiceRuntime.debug(hwfe.getMessage(), hwfe);
                this.recordFailed(serviceReference, hwfe.getFailureReason());
                this.httpServiceRuntime.incrementServiceChangecount();
            }
            catch (Exception e) {
                this.httpServiceRuntime.error(e.getMessage(), e);
                this.recordFailed(serviceReference, 4);
                this.httpServiceRuntime.incrementServiceChangecount();
            }
        }
        finally {
            this.httpServiceRuntime.incrementServiceChangecount();
        }
        return result;
    }

    public void modifiedService(ServiceReference<Preprocessor> serviceReference, AtomicReference<PreprocessorRegistration> reference) {
        this.removedService(serviceReference, reference);
        Object added = this.addingService((ServiceReference)serviceReference);
        reference.set((PreprocessorRegistration)((AtomicReference)added).get());
    }

    public void removedService(ServiceReference<Preprocessor> serviceReference, AtomicReference<PreprocessorRegistration> reference) {
        try {
            PreprocessorRegistration registration = reference.get();
            if (registration != null) {
                registration.destroy();
            }
            this.removeFailed(serviceReference);
        }
        finally {
            this.httpServiceRuntime.incrementServiceChangecount();
        }
    }

    void removeFailed(ServiceReference<Preprocessor> serviceReference) {
        this.httpServiceRuntime.removeFailedPreprocessorDTO(serviceReference);
    }

    private void recordFailed(ServiceReference<Preprocessor> serviceReference, int failureReason) {
        FailedPreprocessorDTO failedPreprocessorDTO = new FailedPreprocessorDTO();
        failedPreprocessorDTO.failureReason = failureReason;
        failedPreprocessorDTO.initParams = ServiceProperties.parseInitParams(serviceReference, "preprocessor.init.");
        failedPreprocessorDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        this.httpServiceRuntime.recordFailedPreprocessorDTO(serviceReference, failedPreprocessorDTO);
    }

    private PreprocessorRegistration addPreprocessorRegistration(ServiceReference<Preprocessor> preprocessorRef) throws ServletException {
        ServiceHolder<Preprocessor> preprocessorHolder = new ServiceHolder<Preprocessor>(this.httpServiceRuntime.getConsumingContext().getServiceObjects(preprocessorRef));
        Preprocessor preprocessor = (Preprocessor)preprocessorHolder.get();
        PreprocessorRegistration registration = null;
        boolean addedRegisteredObject = false;
        try {
            if (preprocessor == null) {
                throw new IllegalArgumentException("Preprocessor cannot be null");
            }
            addedRegisteredObject = this.httpServiceRuntime.getRegisteredObjects().add(preprocessor);
            if (!addedRegisteredObject) {
                throw new HttpWhiteboardFailureException("Multiple registration of instance detected. Prototype scope is recommended: " + preprocessorRef, 7);
            }
            registration = this.doAddPreprocessorRegistration(preprocessorHolder, preprocessorRef);
        }
        finally {
            if (registration == null) {
                preprocessorHolder.release();
                if (addedRegisteredObject) {
                    this.httpServiceRuntime.getRegisteredObjects().remove(preprocessor);
                }
            }
        }
        return registration;
    }

    private PreprocessorRegistration doAddPreprocessorRegistration(ServiceHolder<Preprocessor> preprocessorHolder, ServiceReference<Preprocessor> preprocessorRef) throws ServletException {
        PreprocessorDTO preprocessorDTO = new PreprocessorDTO();
        preprocessorDTO.initParams = ServiceProperties.parseInitParams(preprocessorRef, "preprocessor.init.");
        preprocessorDTO.serviceId = preprocessorHolder.getServiceId();
        PreprocessorRegistration newRegistration = new PreprocessorRegistration(preprocessorHolder, preprocessorDTO, this.httpServiceRuntime);
        FilterConfigImpl filterConfig = new FilterConfigImpl(preprocessorHolder.get().getClass().getCanonicalName(), preprocessorDTO.initParams, this.httpServiceRuntime.getParentServletContext());
        newRegistration.init(filterConfig);
        this.httpServiceRuntime.getPreprocessorRegistrations().put(preprocessorHolder.getServiceReference(), newRegistration);
        return newRegistration;
    }
}

