/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.textsize;

import org.eclipse.rap.rwt.internal.RWTProperties;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rap.rwt.internal.textsize.Probe;
import org.eclipse.rap.rwt.internal.textsize.ProbeResult;
import org.eclipse.rap.rwt.internal.textsize.ProbeResultStore;
import org.eclipse.rap.rwt.internal.textsize.TextSizeEstimation;
import org.eclipse.rap.rwt.internal.textsize.TextSizeRecalculation;
import org.eclipse.rap.rwt.internal.textsize.TextSizeStorageUtil;
import org.eclipse.rap.rwt.internal.util.EncodingUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.FontUtil;

public class TextSizeUtil {
    static final int STRING_EXTENT = 0;
    static final int TEXT_EXTENT = 1;
    static final int MARKUP_EXTENT = 2;
    static boolean loadTestsEnabled = RWTProperties.isLoadTestsEnabled();

    public static Point stringExtent(Font font, String string, boolean markup) {
        if (markup) {
            return TextSizeUtil.determineTextSize(font, string, -1, 2);
        }
        return TextSizeUtil.stringExtent(font, string);
    }

    public static Point stringExtent(Font font, String string) {
        if (TextSizeUtil.isEmptyString(string)) {
            return TextSizeUtil.createSizeForEmptyString(font);
        }
        return TextSizeUtil.determineTextSize(font, string, -1, 0);
    }

    public static Point textExtent(Font font, String text, int wrapWidth, boolean markup) {
        if (markup) {
            return TextSizeUtil.determineTextSize(font, text, wrapWidth, 2);
        }
        return TextSizeUtil.textExtent(font, text, wrapWidth);
    }

    public static Point textExtent(Font font, String text, int wrapWidth) {
        return TextSizeUtil.determineTextSize(font, text, wrapWidth, 1);
    }

    public static int getCharHeight(Font font) {
        int result;
        if (loadTestsEnabled) {
            TextSizeUtil.ensureFontProbeResult(font);
        }
        if (TextSizeUtil.containsProbeResult(font)) {
            result = TextSizeUtil.lookupCharHeight(font);
        } else {
            result = TextSizeUtil.estimateCharHeight(font);
            TextSizeUtil.addProbeToMeasure(font);
        }
        return result;
    }

    public static float getAvgCharWidth(Font font) {
        float result;
        if (loadTestsEnabled) {
            TextSizeUtil.ensureFontProbeResult(font);
        }
        if (TextSizeUtil.containsProbeResult(font)) {
            result = TextSizeUtil.lookupAvgCharWidth(font);
        } else {
            result = TextSizeUtil.estimateAvgCharWidth(font);
            TextSizeUtil.addProbeToMeasure(font);
        }
        return result;
    }

    public static boolean isTemporaryResize() {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        Object attribute = serviceStore.getAttribute(TextSizeRecalculation.TEMPORARY_RESIZE);
        return Boolean.TRUE.equals(attribute);
    }

    private static Point createSizeForEmptyString(Font font) {
        return new Point(0, TextSizeUtil.getCharHeight(font));
    }

    private static boolean isEmptyString(String string) {
        return string.length() == 0;
    }

    private static Point determineTextSize(Font font, String string, int wrapWidth, int mode) {
        int normalizedWrapWidth;
        Point result;
        if (loadTestsEnabled) {
            TextSizeUtil.ensureFontProbeResult(font);
        }
        if ((result = TextSizeUtil.lookup(font, string, normalizedWrapWidth = TextSizeUtil.normalizeWrapWidth(wrapWidth), mode)) == null) {
            result = TextSizeUtil.estimate(font, string, normalizedWrapWidth, mode);
            if (loadTestsEnabled) {
                TextSizeUtil.store(font, string, normalizedWrapWidth, mode, result);
            } else if (!TextSizeUtil.isTemporaryResize()) {
                TextSizeUtil.addItemToMeasure(font, string, normalizedWrapWidth, mode);
            }
        }
        if (TextSizeUtil.isHeightZero(result)) {
            result = TextSizeUtil.adjustHeightForWhitespaceTexts(font, result);
        }
        return result;
    }

    private static int normalizeWrapWidth(int wrapWidth) {
        return wrapWidth <= 0 ? -1 : wrapWidth;
    }

    private static boolean isHeightZero(Point result) {
        return result.y == 0;
    }

    private static Point lookup(Font font, String string, int wrapWidth, int mode) {
        String measurementString = TextSizeUtil.createMeasurementString(string, mode);
        FontData fontData = FontUtil.getData(font);
        return TextSizeStorageUtil.lookup(fontData, measurementString, wrapWidth, mode);
    }

    private static void store(Font font, String string, int wrapWidth, int mode, Point size) {
        String measurementString = TextSizeUtil.createMeasurementString(string, mode);
        FontData fontData = FontUtil.getData(font);
        TextSizeStorageUtil.store(fontData, measurementString, wrapWidth, mode, size);
    }

    private static void ensureFontProbeResult(Font font) {
        if (!TextSizeUtil.containsProbeResult(font)) {
            TextSizeUtil.storeProbeResult(font, TextSizeUtil.estimate(font, Probe.DEFAULT_PROBE_STRING, -1, 0));
        }
    }

    private static void storeProbeResult(Font font, Point size) {
        FontData fontData = FontUtil.getData(font);
        Probe probe = new Probe(fontData);
        ProbeResultStore.getInstance().createProbeResult(probe, size);
    }

    private static Point estimate(Font font, String string, int wrapWidth, int mode) {
        return switch (mode) {
            case 0 -> TextSizeEstimation.stringExtent(font, string);
            case 1 -> TextSizeEstimation.textExtent(font, string, wrapWidth);
            case 2 -> TextSizeEstimation.markupExtent(font, string, wrapWidth);
            default -> throw new IllegalStateException("Unknown estimation mode.");
        };
    }

    private static void addItemToMeasure(Font font, String string, int wrapWidth, int mode) {
        String measurementString = TextSizeUtil.createMeasurementString(string, mode);
        MeasurementUtil.addItemToMeasure(measurementString, font, wrapWidth, mode);
    }

    private static String createMeasurementString(String string, int mode) {
        return mode == 0 ? EncodingUtil.replaceNewLines(string, " ") : string;
    }

    private static Point adjustHeightForWhitespaceTexts(Font font, Point result) {
        return new Point(result.x, TextSizeUtil.getCharHeight(font));
    }

    private static void addProbeToMeasure(Font font) {
        MeasurementUtil.getMeasurementOperator().addProbeToMeasure(FontUtil.getData(font));
    }

    private static int estimateCharHeight(Font font) {
        return TextSizeEstimation.getCharHeight(font);
    }

    private static int lookupCharHeight(Font font) {
        return TextSizeUtil.getProbeResult((Font)font).getSize().y;
    }

    private static boolean containsProbeResult(Font font) {
        return ProbeResultStore.getInstance().containsProbeResult(FontUtil.getData(font));
    }

    private static float estimateAvgCharWidth(Font font) {
        return TextSizeEstimation.getAvgCharWidth(font);
    }

    private static float lookupAvgCharWidth(Font font) {
        return TextSizeUtil.getProbeResult(font).getAvgCharWidth();
    }

    private static ProbeResult getProbeResult(Font font) {
        FontData data = FontUtil.getData(font);
        return ProbeResultStore.getInstance().getProbeResult(data);
    }

    private TextSizeUtil() {
    }
}

