/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.server.ClientSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionEventManager
implements Cloneable,
Serializable {
    protected List<SessionEventListener> listeners = new ArrayList<SessionEventListener>();
    protected Session session;

    public SessionEventManager() {
    }

    public SessionEventManager(Session session) {
        this.session = session;
    }

    public void addListener(SessionEventListener listener) {
        this.getListeners().add(listener);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            return new InternalError(exception.toString());
        }
    }

    public SessionEventManager clone(Session newSession) {
        SessionEventManager newManager = (SessionEventManager)this.clone();
        newManager.setSession(newSession);
        if (this.listeners != null) {
            newManager.setListeners(new ArrayList<SessionEventListener>(this.listeners));
        }
        return newManager;
    }

    public List<SessionEventListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<SessionEventListener>();
        }
        return this.listeners;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void missingDescriptor(Class missingClass) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(32, this.getSession());
        event.setResult(missingClass);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).missingDescriptor(event);
        }
        this.endOperationProfile();
    }

    public void moreRowsDetected(DatabaseCall call) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(20, this.getSession());
        event.setResult(call);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).moreRowsDetected(event);
        }
        this.endOperationProfile();
    }

    public void noRowsModified(ModifyQuery query, Object object) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(35, this.getSession());
        event.setQuery(query);
        event.setResult(object);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).noRowsModified(event);
        }
        this.endOperationProfile();
    }

    public void outputParametersDetected(Record outputRow, DatasourceCall call) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(19, this.getSession());
        event.setResult(outputRow);
        event.setProperty("call", call);
        event.setQuery(call.getQuery());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).outputParametersDetected(event);
        }
        this.endOperationProfile();
    }

    public void postAcquireClientSession() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(16, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postAcquireClientSession(event);
        }
        this.endOperationProfile();
    }

    public void postAcquireConnection(Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(22, this.getSession());
        event.setResult(accessor);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postAcquireConnection(event);
        }
        this.endOperationProfile();
    }

    public void postAcquireExclusiveConnection(ClientSession clientSession, Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        SessionEvent event = new SessionEvent(33, clientSession);
        event.setResult(accessor);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postAcquireExclusiveConnection(event);
        }
    }

    public void postAcquireUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(9, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postAcquireUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void postBeginTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(4, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postBeginTransaction(event);
        }
        this.endOperationProfile();
    }

    public void postCommitTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(6, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postCommitTransaction(event);
        }
        this.endOperationProfile();
    }

    public void postCommitUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(11, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postCommitUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void postConnect(Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(21, this.getSession());
        event.setResult(accessor);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postConnect(event);
        }
        this.endOperationProfile();
    }

    public void postExecuteQuery(DatabaseQuery query, Object result) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(2, this.getSession());
        event.setQuery(query);
        event.setResult(result);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postExecuteQuery(event);
        }
        this.endOperationProfile();
    }

    public void postReleaseClientSession() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(18, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postReleaseClientSession(event);
        }
        this.endOperationProfile();
    }

    public void postReleaseUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(13, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postReleaseUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void postResumeUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(15, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postResumeUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void postRollbackTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(8, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postRollbackTransaction(event);
        }
        this.endOperationProfile();
    }

    public void postDistributedMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(29, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postDistributedMergeUnitOfWorkChangeSet(event);
        }
        this.endOperationProfile();
    }

    public void postMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(28, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postMergeUnitOfWorkChangeSet(event);
        }
        this.endOperationProfile();
    }

    public void preBeginTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(3, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preBeginTransaction(event);
        }
        this.endOperationProfile();
    }

    public void preCalculateUnitOfWorkChangeSet() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(30, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preCalculateUnitOfWorkChangeSet(event);
        }
        this.endOperationProfile();
    }

    public void postCalculateUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(31, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postCalculateUnitOfWorkChangeSet(event);
        }
        this.endOperationProfile();
    }

    public void preCommitTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(5, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preCommitTransaction(event);
        }
        this.endOperationProfile();
    }

    public void preCommitUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(10, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preCommitUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void preExecuteQuery(DatabaseQuery query) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(1, this.getSession());
        event.setQuery(query);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preExecuteQuery(event);
        }
        this.endOperationProfile();
    }

    public void preLogin(Session session) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(24, session);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preLogin(event);
        }
        this.endOperationProfile();
    }

    public void postLogin(Session session) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(25, session);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).postLogin(event);
        }
        this.endOperationProfile();
    }

    public void prepareUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(14, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).prepareUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void preReleaseClientSession() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(17, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preReleaseClientSession(event);
        }
        this.endOperationProfile();
    }

    public void preReleaseConnection(Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(23, this.getSession());
        event.setResult(accessor);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preReleaseConnection(event);
        }
        this.endOperationProfile();
    }

    public void preReleaseExclusiveConnection(ClientSession clientSession, Accessor accessor) {
        if (!this.hasListeners()) {
            return;
        }
        SessionEvent event = new SessionEvent(34, clientSession);
        event.setResult(accessor);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preReleaseExclusiveConnection(event);
        }
    }

    public void preReleaseUnitOfWork() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(12, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preReleaseUnitOfWork(event);
        }
        this.endOperationProfile();
    }

    public void preRollbackTransaction() {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(7, this.getSession());
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preRollbackTransaction(event);
        }
        this.endOperationProfile();
    }

    public void preDistributedMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(27, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preDistributedMergeUnitOfWorkChangeSet(event);
        }
        this.endOperationProfile();
    }

    public void preMergeUnitOfWorkChangeSet(UnitOfWorkChangeSet changeSet) {
        if (!this.hasListeners()) {
            return;
        }
        this.startOperationProfile();
        SessionEvent event = new SessionEvent(26, this.getSession());
        event.setProperty("UnitOfWorkChangeSet", changeSet);
        int size = this.listeners.size();
        for (int index = 0; index < size; ++index) {
            this.listeners.get(index).preMergeUnitOfWorkChangeSet(event);
        }
        this.endOperationProfile();
    }

    public void removeListener(SessionEventListener listener) {
        this.getListeners().remove(listener);
    }

    protected void setListeners(List<SessionEventListener> listeners) {
        this.listeners = listeners;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    protected void startOperationProfile() {
        if (this.getSession().isInProfile()) {
            this.getSession().getProfiler().startOperationProfile("SessionEvents");
        }
    }

    protected void endOperationProfile() {
        if (this.getSession().isInProfile()) {
            this.getSession().getProfiler().endOperationProfile("SessionEvents");
        }
    }
}

