/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.File;
import java.net.URL;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class PersistenceUnitLoadingException
extends EclipseLinkException {
    private String resourceName = null;
    public static final int EXCEPTION_LOADING_FROM_DIRECTORY = 30001;
    public static final int EXCEPTION_LOADING_FROM_JAR = 30002;
    public static final int EXCEPTION_PROCESSING_PERSISTENCE_UNIT = 30003;
    public static final int EXCEPTION_PROCESSING_PERSISTENCE_XML = 30004;
    public static final int EXCEPTION_SEARCHING_FOR_PERSISTENCE_RESOURCES = 30005;
    public static final int EXCEPTION_SEARCHING_FOR_ENTITIES = 30006;
    public static final int EXCEPTION_LOADING_CLASS = 30007;
    public static final int FILE_PATH_MISSING_EXCEPTION = 30008;
    public static final int EXCEPTION_LOADING_FROM_URL = 30009;
    public static final int EXCEPTION_OPENING_ORM_XML = 30010;
    public static final int COULD_NOT_GET_CLASS_NAMES_FROM_URL = 30011;
    public static final int COULD_NOT_GET_PERSISTENCE_UNIT_INFO_FROM_URL = 30012;
    public static final int EXCEPTION_BUILDING_PERSISTENCE_UNIT_NAME = 30013;
    public static final int EXCEPTION_OBTAINING_REQUIRED_BEAN_VALIDATOR_FACTORY = 30014;
    public static final int EXCEPTION_LOADING_VALIDATION_GROUP_CLASS = 30015;
    public static final int SESSION_NAME_ALREADY_IN_USE = 30016;
    public static final int PERSISTENCE_UNIT_NAME_ALREADY_IN_USE = 30017;

    public PersistenceUnitLoadingException() {
    }

    protected PersistenceUnitLoadingException(String message) {
        super(message);
    }

    protected PersistenceUnitLoadingException(String message, Throwable internalException) {
        super(message);
        this.setInternalException(internalException);
    }

    public static PersistenceUnitLoadingException exceptionLoadingFromDirectory(File directory, Exception cause) {
        Object[] args = new Object[]{directory};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30001, args), cause);
        loadingException.setResourceName(directory.toString());
        loadingException.setErrorCode(30001);
        return loadingException;
    }

    public static PersistenceUnitLoadingException filePathMissingException(String filePath) {
        Object[] args = new Object[]{filePath};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30008, args));
        loadingException.setResourceName(filePath);
        loadingException.setErrorCode(30008);
        return loadingException;
    }

    public static PersistenceUnitLoadingException exceptionLoadingFromJar(URL jarFile, Exception cause) {
        Object[] args = new Object[]{jarFile};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30002, args), cause);
        loadingException.setResourceName(jarFile.toString());
        loadingException.setErrorCode(30002);
        return loadingException;
    }

    public static PersistenceUnitLoadingException exceptionLoadingFromUrl(String url, Exception cause) {
        Object[] args = new Object[]{url};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30009, args), cause);
        loadingException.setResourceName(url);
        loadingException.setErrorCode(30009);
        return loadingException;
    }

    public static PersistenceUnitLoadingException exceptionProcessingPersistenceUnit(URL url, Exception cause) {
        Object[] args = new Object[]{url};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30003, args), cause);
        loadingException.setResourceName(url.toString());
        loadingException.setErrorCode(30003);
        return loadingException;
    }

    public static PersistenceUnitLoadingException exceptionProcessingPersistenceXML(URL url, Exception cause) {
        Object[] args = new Object[]{url};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30004, args), cause);
        loadingException.setResourceName(url.toString());
        loadingException.setErrorCode(30004);
        return loadingException;
    }

    public static PersistenceUnitLoadingException exceptionSearchingForPersistenceResources(ClassLoader loader, Exception cause) {
        Object[] args = new Object[]{loader};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30005, args), cause);
        loadingException.setErrorCode(30005);
        return loadingException;
    }

    public static PersistenceUnitLoadingException exceptionSearchingForEntities(URL url, Exception cause) {
        Object[] args = new Object[]{url};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30006, args), cause);
        loadingException.setResourceName(url.toString());
        loadingException.setErrorCode(30006);
        return loadingException;
    }

    public static PersistenceUnitLoadingException exceptionLoadingClassWhileLookingForAnnotations(String className, Exception cause) {
        Object[] args = new Object[]{className};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30007, args), cause);
        loadingException.setErrorCode(30007);
        return loadingException;
    }

    public static PersistenceUnitLoadingException exceptionLoadingORMXML(String fileName, Exception cause) {
        Object[] args = new Object[]{fileName};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30010, args), cause);
        loadingException.setResourceName(fileName);
        loadingException.setErrorCode(30010);
        return loadingException;
    }

    public static PersistenceUnitLoadingException couldNotGetClassNamesFromUrl(URL url) {
        Object[] args = new Object[]{url};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30011, args));
        loadingException.setResourceName(url.toString());
        loadingException.setErrorCode(30011);
        return loadingException;
    }

    public static PersistenceUnitLoadingException couldNotGetUnitInfoFromUrl(URL url) {
        Object[] args = new Object[]{url};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30012, args));
        loadingException.setResourceName(url.toString());
        loadingException.setErrorCode(30012);
        return loadingException;
    }

    public static PersistenceUnitLoadingException couldNotBuildPersistenceUntiName(Exception e, String url, String puName) {
        Object[] args = new Object[]{url, puName};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30013, args), e);
        loadingException.setErrorCode(30013);
        return loadingException;
    }

    public static PersistenceUnitLoadingException exceptionObtainingRequiredBeanValidatorFactory(Throwable cause) {
        Object[] args = new Object[]{};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30014, args), cause);
        loadingException.setErrorCode(30014);
        return loadingException;
    }

    public static PersistenceUnitLoadingException exceptionLoadingClassWhileInitializingValidationGroups(String className, Exception cause) {
        Object[] args = new Object[]{className};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30015, args), cause);
        loadingException.setErrorCode(30015);
        return loadingException;
    }

    public static PersistenceUnitLoadingException sessionNameAlreadyInUse(String sessionName, String newPersistenceUnit, String existingPersistenceUnit) {
        Object[] args = new Object[]{sessionName, newPersistenceUnit, existingPersistenceUnit};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30016, args));
        loadingException.setErrorCode(30016);
        return loadingException;
    }

    public static PersistenceUnitLoadingException persistenceUnitNameAlreadyInUse(String persistenceUnit, String newPersistenceUnitUrl, String existingPersistenceUnitUrl) {
        Object[] args = new Object[]{persistenceUnit, newPersistenceUnitUrl, existingPersistenceUnitUrl};
        PersistenceUnitLoadingException loadingException = new PersistenceUnitLoadingException(ExceptionMessageGenerator.buildMessage(PersistenceUnitLoadingException.class, 30017, args));
        loadingException.setErrorCode(30017);
        return loadingException;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }
}

