/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.Depth;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiKeyOperation;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.util.ObjectUtil;

public abstract class MultiTableOperation
extends MultiKeyOperation {
    private final TargetTables targetTables;
    private final int emptyReadFactor;

    public MultiTableOperation(InternalOperation.OpCode opCode, byte[] parentKey, TargetTables targetTables, KeyRange subRange) {
        this(opCode, parentKey, targetTables, subRange, 1);
    }

    public MultiTableOperation(InternalOperation.OpCode opCode, byte[] parentKey, TargetTables targetTables, KeyRange subRange, int emptyReadFactor) {
        super(opCode, parentKey, subRange, Depth.PARENT_AND_DESCENDANTS);
        ObjectUtil.checkNull("targetTables", targetTables);
        this.targetTables = targetTables;
        assert (emptyReadFactor <= 127);
        this.emptyReadFactor = emptyReadFactor;
    }

    MultiTableOperation(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        this.targetTables = new TargetTables(in, serialVersion);
        this.emptyReadFactor = serialVersion >= 16 ? (int)in.readByte() : 1;
    }

    TargetTables getTargetTables() {
        return this.targetTables;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.targetTables.writeFastExternal(out, serialVersion);
        if (serialVersion >= 16) {
            out.writeByte(this.emptyReadFactor);
        }
    }

    @Override
    public long getTableId() {
        return this.targetTables.getTargetTableId();
    }

    @Override
    public void addEmptyReadCharge() {
        if (this.getReadKB() == 0) {
            this.addReadBytes(this.emptyReadFactor * 1024);
        }
    }
}

