/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.Geometry;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class FuncGeoIsGeometryIter
extends PlanIter {
    private final PlanIter theInput;

    public FuncGeoIsGeometryIter(Expr e, int resultReg, PlanIter[] argIters) {
        super(e, resultReg);
        this.theInput = argIters[0];
    }

    FuncGeoIsGeometryIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInput = FuncGeoIsGeometryIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        FuncGeoIsGeometryIter.serializeIter(this.theInput, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.GEO_IS_GEOMETRY;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        this.theInput.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        boolean res;
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more = this.theInput.next(rcb);
        if (!more) {
            res = false;
        } else {
            more = this.theInput.next(rcb);
            if (more) {
                res = false;
            } else {
                FieldValueImpl val = rcb.getRegVal(this.theInput.getResultReg());
                if (val.isNull()) {
                    rcb.setRegVal(this.theResultReg, val);
                    state.done();
                    return true;
                }
                Geometry geom = CompilerAPI.getGeoUtils().castAsGeometry(val);
                boolean bl = res = geom != null;
            }
        }
        if (res) {
            rcb.setRegVal(this.theResultReg, BooleanValueImpl.trueValue);
        } else {
            rcb.setRegVal(this.theResultReg, BooleanValueImpl.falseValue);
        }
        state.done();
        return true;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
    }
}

