/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.async.DialogContext;
import oracle.kv.impl.async.DialogHandler;
import oracle.kv.impl.async.MessageInput;
import oracle.kv.impl.async.MessageOutput;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.util.ObjectUtil;

public class NullDialogStart {
    private static final ScheduledExecutorService nullExecutor = new NullExecutor();
    private static final NullContext nullContext = new NullContext();
    private static final ThreadLocal<Boolean> failingDialog = ThreadLocal.withInitial(() -> false);

    public static void fail(DialogHandler handler, Throwable cause, ExecutorService executor) {
        ObjectUtil.checkNull("executor", executor);
        if (!failingDialog.get().booleanValue()) {
            NullDialogStart.doFail(handler, cause);
            return;
        }
        if (executor != null) {
            try {
                executor.submit(() -> NullDialogStart.doFail(handler, cause));
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        throw new IllegalStateException(String.format("Detected recursion inside the onAbort method of handler [%s] for cause [%s] when the executor is unavailable", handler, cause));
    }

    private static void doFail(DialogHandler handler, Throwable cause) {
        failingDialog.set(true);
        try {
            handler.onStart(nullContext, true);
        }
        finally {
            try {
                handler.onAbort(nullContext, cause);
            }
            catch (Throwable throwable) {}
            failingDialog.set(false);
        }
    }

    private static class NullExecutor
    extends AbstractExecutorService
    implements ScheduledExecutorService {
        private NullExecutor() {
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }

        @Override
        public boolean isShutdown() {
            return true;
        }

        @Override
        public boolean isTerminated() {
            return true;
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public void execute(Runnable command) {
            throw new RejectedExecutionException();
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            throw new RejectedExecutionException();
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            throw new RejectedExecutionException();
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            throw new RejectedExecutionException();
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            throw new RejectedExecutionException();
        }
    }

    private static class NullContext
    implements DialogContext {
        private NullContext() {
        }

        @Override
        public boolean write(MessageOutput mesg, boolean finished) {
            return false;
        }

        @Override
        public MessageInput read() {
            return null;
        }

        @Override
        public long getDialogId() {
            return 0L;
        }

        @Override
        public long getConnectionId() {
            return 0L;
        }

        @Override
        public NetworkAddress getRemoteAddress() {
            return null;
        }

        @Override
        public ScheduledExecutorService getSchedExecService() {
            return nullExecutor;
        }

        public String toString() {
            return "NullContext";
        }
    }
}

