/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.query;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.kv.StatementResult;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.query.BoundStatementImpl;
import oracle.kv.impl.api.query.InternalStatement;
import oracle.kv.impl.api.query.QueryStatementResultImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldDefSerialization;
import oracle.kv.impl.api.table.FieldMap;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.async.AsyncIterationHandleImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.query.BoundStatement;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.query.PreparedStatement;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;

public class PreparedStatementImpl
implements PreparedStatement,
InternalStatement {
    private final PlanIter queryPlan;
    private final RecordDefImpl resultDef;
    private boolean wrapResultInRecord;
    private final int numRegisters;
    private final int numIterators;
    private final Map<String, StaticContext.VarInfo> externalVars;
    private final DistributionKind distributionKind;
    private final PartitionId partitionId;
    private final PrimaryKeyImpl shardKey;
    private final long tableId;
    private final int tableVersion;
    private final String tableName;
    private QueryControlBlock qcb;

    public PreparedStatementImpl(PlanIter queryPlan, FieldDefImpl resultDef, int numRegisters, int numIterators, Map<String, StaticContext.VarInfo> externalVars, QueryControlBlock qcb) {
        this.queryPlan = queryPlan;
        this.numRegisters = numRegisters;
        this.numIterators = numIterators;
        this.externalVars = externalVars;
        this.qcb = qcb;
        this.distributionKind = qcb.getPushedDistributionKind();
        this.tableId = qcb.getTargetTableId();
        this.tableVersion = qcb.getTargetTableVersion();
        this.tableName = qcb.getTargetTableName();
        PrimaryKeyImpl pkey = qcb.getPushedPrimaryKey();
        this.shardKey = pkey != null && pkey.isEmpty() ? null : pkey;
        this.partitionId = this.shardKey != null && this.distributionKind == DistributionKind.SINGLE_PARTITION ? this.shardKey.getPartitionId(qcb.getStore()) : PartitionId.NULL_ID;
        if (qcb.wrapResultInRecord()) {
            this.wrapResultInRecord = true;
            String fname = qcb.getResultColumnName();
            if (fname == null) {
                fname = "Column_1";
            }
            FieldMap fieldMap = new FieldMap();
            fieldMap.put(fname, resultDef, true, null);
            this.resultDef = FieldDefFactory.createRecordDef(fieldMap, null);
        } else {
            this.wrapResultInRecord = false;
            this.resultDef = (RecordDefImpl)resultDef;
        }
    }

    @Override
    public RecordDef getResultDef() {
        return this.resultDef;
    }

    boolean wrapResultInRecord() {
        return this.wrapResultInRecord;
    }

    @Override
    public Map<String, FieldDef> getVariableTypes() {
        return this.getExternalVarsTypes();
    }

    @Override
    public FieldDef getVariableType(String variableName) {
        return this.getExternalVarType(variableName);
    }

    @Override
    public BoundStatement createBoundStatement() {
        return new BoundStatementImpl(this);
    }

    public boolean hasSort() {
        return this.qcb.hasSort();
    }

    public QueryControlBlock getQCB() {
        return this.qcb;
    }

    public PlanIter getQueryPlan() {
        return this.queryPlan;
    }

    public int getNumRegisters() {
        return this.numRegisters;
    }

    public int getNumIterators() {
        return this.numIterators;
    }

    public Map<String, FieldDef> getExternalVarsTypes() {
        HashMap<String, FieldDef> varsMap = new HashMap<String, FieldDef>();
        if (this.externalVars == null) {
            return varsMap;
        }
        for (Map.Entry<String, StaticContext.VarInfo> entry : this.externalVars.entrySet()) {
            String varName = entry.getKey();
            StaticContext.VarInfo vi = entry.getValue();
            varsMap.put(varName, vi.getType().getDef());
        }
        return varsMap;
    }

    boolean hasExternalVars() {
        return this.externalVars != null && !this.externalVars.isEmpty();
    }

    public FieldDef getExternalVarType(String name) {
        if (this.externalVars == null) {
            return null;
        }
        StaticContext.VarInfo vi = this.externalVars.get(name);
        if (vi != null) {
            return vi.getType().getDef();
        }
        return null;
    }

    long getTableId() {
        return this.tableId;
    }

    public int getTableVersion() {
        return this.tableVersion;
    }

    public String getTableName() {
        return this.tableName;
    }

    public FieldValue[] getExternalVarsArray(Map<String, FieldValue> vars) {
        if (this.externalVars == null) {
            assert (vars.isEmpty());
            return null;
        }
        int count = 0;
        for (Map.Entry<String, StaticContext.VarInfo> entry : this.externalVars.entrySet()) {
            String name = entry.getKey();
            ++count;
            if (vars.get(name) != null) continue;
            throw new IllegalArgumentException("Variable " + name + " has not been bound");
        }
        FieldValue[] array = new FieldValue[count];
        count = 0;
        for (Map.Entry<String, FieldValue> entry : vars.entrySet()) {
            String name = entry.getKey();
            FieldValue value = entry.getValue();
            StaticContext.VarInfo vi = this.externalVars.get(name);
            if (vi == null) {
                throw new IllegalStateException("Variable " + name + " does not appear in query");
            }
            array[vi.getId()] = value;
            ++count;
        }
        assert (count == array.length);
        return array;
    }

    public String toString() {
        return this.queryPlan.display();
    }

    @Override
    public StatementResult executeSync(KVStoreImpl store, ExecuteOptions options) {
        if (options == null) {
            options = new ExecuteOptions();
        }
        return new QueryStatementResultImpl(store.getTableAPIImpl(), options, this, false);
    }

    @Override
    public AsyncIterationHandleImpl<RecordValue> executeAsync(KVStoreImpl store, ExecuteOptions options) {
        if (options == null) {
            options = new ExecuteOptions();
        }
        QueryStatementResultImpl result = new QueryStatementResultImpl(store.getTableAPIImpl(), options, this, true);
        return result.getExecutionHandle();
    }

    public DistributionKind getDistributionKind() {
        return this.distributionKind;
    }

    public PrimaryKey getShardKey() {
        return this.shardKey;
    }

    public PartitionId getPartitionId() {
        return this.partitionId;
    }

    public StatementResult executeSyncPartitions(KVStoreImpl store, ExecuteOptions options, Set<Integer> partitions) {
        return new QueryStatementResultImpl(store.getTableAPIImpl(), options, this, false, partitions, null);
    }

    public StatementResult executeSyncShards(KVStoreImpl store, ExecuteOptions options, Set<RepGroupId> shards) {
        return new QueryStatementResultImpl(store.getTableAPIImpl(), options, this, false, null, shards);
    }

    public byte[] toByteArray() throws IOException {
        assert (this.qcb != null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        this.toByteArray(out);
        return baos.toByteArray();
    }

    public void toByteArray(DataOutput out) throws IOException {
        short version = SerialVersion.CURRENT;
        out.writeShort(version);
        out.writeByte(this.distributionKind != null ? this.distributionKind.ordinal() : -1);
        SerializationUtil.writeNonNullString(out, version, this.tableName);
        SerializationUtil.writePackedLong(out, this.tableId);
        SerializationUtil.writePackedInt(out, this.tableVersion);
        this.writeExternalVars(out, version);
        PlanIter.serializeIter(this.queryPlan, out, version);
        out.writeInt(this.numIterators);
        out.writeInt(this.numRegisters);
        FieldDefSerialization.writeFieldDef(this.resultDef, out, version);
        out.writeBoolean(this.wrapResultInRecord);
    }

    public PreparedStatementImpl(DataInput in) throws IOException {
        try {
            byte ordinal;
            short version = in.readShort();
            if (version < 16 || version > SerialVersion.CURRENT) {
                this.raiseDeserializeError("unexpected version value: " + version);
            }
            if ((ordinal = in.readByte()) != -1) {
                if (ordinal < 0 || ordinal > DistributionKind.values().length) {
                    this.raiseDeserializeError("unexpected value for DistributionKind");
                }
                this.distributionKind = DistributionKind.values()[ordinal];
            } else {
                this.distributionKind = null;
            }
            this.tableName = SerializationUtil.readString(in, version);
            if (this.tableName == null) {
                this.raiseDeserializeError("tableName should not be null");
            }
            this.tableId = SerializationUtil.readPackedLong(in);
            if (this.tableId < 0L) {
                this.raiseDeserializeError("tableId should not be negative value");
            }
            this.tableVersion = SerializationUtil.readPackedInt(in);
            if (this.tableVersion < 0) {
                this.raiseDeserializeError("tableVersion should not be negative value");
            }
            this.externalVars = this.readExternalVars(in, version);
            this.queryPlan = PlanIter.deserializeIter(in, version);
            if (this.queryPlan == null) {
                this.raiseDeserializeError("query plan is null");
            }
            this.numIterators = in.readInt();
            if (this.numIterators < 1) {
                this.raiseDeserializeError("numIterators should not be 0 or negative value");
            }
            this.numRegisters = in.readInt();
            if (this.numRegisters < 0) {
                this.raiseDeserializeError("numRegisters should not be 0 or negative value");
            }
            this.resultDef = (RecordDefImpl)FieldDefSerialization.readFieldDef(in, version);
            this.wrapResultInRecord = in.readBoolean();
            this.partitionId = null;
            this.shardKey = null;
        }
        catch (QueryException qe) {
            throw qe.getIllegalArgument();
        }
        catch (RuntimeException re) {
            throw new IllegalArgumentException("Read PreparedStatement failed: " + re);
        }
    }

    private void raiseDeserializeError(String msg) {
        throw new QueryException("Deserializing PreparedStatement failed: " + msg);
    }

    private void writeExternalVars(DataOutput out, short version) throws IOException {
        if (this.externalVars == null) {
            out.writeInt(0);
        }
        out.writeInt(this.externalVars.size());
        for (Map.Entry<String, StaticContext.VarInfo> entry : this.externalVars.entrySet()) {
            SerializationUtil.writeNonNullString(out, version, entry.getKey());
            StaticContext.VarInfo info = entry.getValue();
            out.writeInt(info.getId());
            PlanIter.serializeExprType(info.getType(), out, version);
        }
    }

    private Map<String, StaticContext.VarInfo> readExternalVars(DataInput in, short version) throws IOException {
        int numVars = in.readInt();
        if (numVars == 0) {
            return null;
        }
        if (numVars < 0) {
            this.raiseDeserializeError("Unexpected negtive value: " + numVars);
        }
        try {
            HashMap<String, StaticContext.VarInfo> vars = new HashMap<String, StaticContext.VarInfo>(numVars);
            for (int i = 0; i < numVars; ++i) {
                String name = SerializationUtil.readString(in, version);
                StaticContext.VarInfo info = StaticContext.VarInfo.createVarInfo(in.readInt(), PlanIter.deserializeExprType(in, version));
                vars.put(name, info);
            }
            return vars;
        }
        catch (RuntimeException re) {
            this.raiseDeserializeError(re.getMessage());
            return null;
        }
    }

    public static enum DistributionKind {
        SINGLE_PARTITION,
        ALL_PARTITIONS,
        ALL_SHARDS,
        UNKNOWN;

    }
}

