/*
 * Copyright (c) 1998, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Denise Smith  January 26, 2010 - 2.0.1
package org.eclipse.persistence.testing.jaxb.xmlelementref.missingref;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlElementDecl;
import jakarta.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;

@XmlRegistry
public class MissingRefObjectFactory {

    private final static QName theQName = new QName("", "arg0");

    public MissingRefObjectFactory() {
    }

    @XmlElementDecl(namespace = "", name = "arg0", scope = Person.class)
    public JAXBElement<byte[]> createEchoByteArrayArg0(byte[] value) {
        return new JAXBElement<byte[]>(theQName, byte[].class, Person.class, ((byte[]) value));
    }
}
