/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class TableNotSpecifiedTest
extends ExceptionTest {
    ClassDescriptor orgDescriptor;
    IntegrityChecker orgIntegrityChecker;

    public TableNotSpecifiedTest() {
        this.setDescription("This tests Table Not Specified (TL-ERROR 94) ");
    }

    protected void setup() {
        this.expectedException = DescriptorException.tableNotSpecified(null);
        this.orgDescriptor = ((DatabaseSession)this.getSession()).getDescriptor(EmploymentPeriod.class);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
    }

    @Override
    public void reset() {
        ((DatabaseSession)this.getSession()).getDescriptors().remove(EmploymentPeriod.class);
        if (this.orgDescriptor != null) {
            ((DatabaseSession)this.getSession()).addDescriptor(this.orgDescriptor);
        }
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        try {
            this.getSession().setIntegrityChecker(new IntegrityChecker());
            this.getSession().getIntegrityChecker().dontCatchExceptions();
            this.buildProject((DatabaseSession)this.getSession());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public void buildProject(DatabaseSession session) {
        session.addDescriptor((ClassDescriptor)this.buildEmploymentPeriodDescriptor());
    }

    public RelationalDescriptor buildEmploymentPeriodDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmploymentPeriod.class);
        return descriptor;
    }
}

