/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.isolatedsession;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestProblemException;

public class ClientServerTest
extends AutoVerifyTestCase {
    protected DatabaseLogin login;
    protected ArrayList clients = new ArrayList();
    protected ServerSession server;
    protected String exclusiveConnectionMode;
    protected boolean isIsolated = true;
    protected Map isolatedDescriptors = new HashMap();

    public ClientServerTest(boolean isExclusive) {
        this(isExclusive ? "Isolated" : "Transactional", true);
    }

    public ClientServerTest(String exclusiveConnectionMode, boolean isIsolated) {
        this.exclusiveConnectionMode = exclusiveConnectionMode;
        this.isIsolated = isIsolated;
        if (exclusiveConnectionMode.equals("Isolated") && !isIsolated) {
            throw new TestProblemException("ExclusiveConnectionMode.Isolated requires isIsolated==true");
        }
        this.setDescription("This test acts as a template for tests using the client server framework");
    }

    public void copyDescriptors(Session session) {
        Vector<ClassDescriptor> descriptors = new Vector<ClassDescriptor>();
        for (ClassDescriptor desc : session.getDescriptors().values()) {
            descriptors.addElement(desc);
            if (this.isIsolated || !desc.isIsolated()) continue;
            this.isolatedDescriptors.put(desc, desc.getUnitOfWorkCacheIsolationLevel());
            desc.setCacheIsolation(CacheIsolationType.SHARED);
            desc.setUnitOfWorkCacheIsolationLevel(1);
        }
        this.server.addDescriptors(descriptors);
        this.server.getProject().setHasIsolatedClasses(true);
    }

    public void reset() {
        block5: {
            try {
                while (!this.clients.isEmpty()) {
                    ((Session)this.clients.get(0)).release();
                    this.clients.remove(0);
                }
                this.server.logout();
                if (!this.isIsolated) {
                    for (Map.Entry entry : this.isolatedDescriptors.entrySet()) {
                        ClassDescriptor desc = (ClassDescriptor)entry.getKey();
                        desc.setCacheIsolation(CacheIsolationType.ISOLATED);
                        desc.setUnitOfWorkCacheIsolationLevel(((Integer)entry.getValue()).intValue());
                    }
                    this.isolatedDescriptors.clear();
                }
                this.getDatabaseSession().logout();
                this.getDatabaseSession().login();
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block5;
                this.verify();
            }
        }
    }

    public void setup() {
        try {
            this.login = (DatabaseLogin)this.getSession().getLogin().clone();
            this.server = new ServerSession((Login)this.login, 2, 5);
            this.server.setSessionLog(this.getSession().getSessionLog());
            this.copyDescriptors(this.getSession());
            this.server.login();
            ConnectionPolicy connectionPolicy = this.server.getDefaultConnectionPolicy();
            if (this.exclusiveConnectionMode.equals("Isolated")) {
                connectionPolicy.setExclusiveMode(ConnectionPolicy.ExclusiveMode.Isolated);
            } else if (this.exclusiveConnectionMode.equals("Always")) {
                connectionPolicy.setExclusiveMode(ConnectionPolicy.ExclusiveMode.Always);
            }
            String propertyName = this.exclusiveConnectionMode;
            if (this.isIsolated) {
                propertyName = propertyName + "_Isolated";
            }
            connectionPolicy.setProperty((Object)propertyName, (Object)"true");
            this.clients.add(this.server.acquireClientSession(connectionPolicy));
            this.clients.add(this.server.acquireClientSession(connectionPolicy));
            this.clients.add(this.server.acquireClientSession(connectionPolicy));
        }
        catch (ValidationException ex) {
            this.verify();
        }
    }

    public void test() {
    }

    public void verify() {
    }
}

