/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.orderedlist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.annotations.OrderCorrectionType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.testing.models.orderedlist.Child;
import org.eclipse.persistence.testing.models.orderedlist.Employee;
import org.eclipse.persistence.testing.models.orderedlist.EmployeeSystem;
import org.eclipse.persistence.testing.models.orderedlist.LargeProject;
import org.eclipse.persistence.testing.models.orderedlist.PhoneNumber;
import org.eclipse.persistence.testing.models.orderedlist.Project;
import org.eclipse.persistence.testing.models.orderedlist.SmallProject;

public class EmployeeProject
extends org.eclipse.persistence.sessions.Project {
    boolean useListOrderField;
    boolean useIndirection;
    boolean isPrivatelyOwned;
    boolean useSecondaryTable;
    boolean useVarcharOrder;
    EmployeeSystem.ChangeTracking changeTracking;
    OrderCorrectionType orderCorrectionType;
    boolean shouldOverrideContainerPolicy;
    EmployeeSystem.JoinFetchOrBatchRead joinFetchOrBatchRead;

    public EmployeeProject(boolean useListOrderField, boolean useIndirection, boolean isPrivatelyOwned, boolean useSecondaryTable, boolean useVarcharOrder, EmployeeSystem.ChangeTracking changeTracking, OrderCorrectionType orderCorrectionType, boolean shouldOverrideContainerPolicy, EmployeeSystem.JoinFetchOrBatchRead joinFetchOrBatchRead) {
        this.useListOrderField = useListOrderField;
        this.useIndirection = useIndirection;
        this.isPrivatelyOwned = isPrivatelyOwned;
        this.useSecondaryTable = useSecondaryTable;
        this.useVarcharOrder = useVarcharOrder;
        this.changeTracking = changeTracking;
        this.orderCorrectionType = orderCorrectionType;
        this.shouldOverrideContainerPolicy = shouldOverrideContainerPolicy;
        this.joinFetchOrBatchRead = joinFetchOrBatchRead;
        this.setName("OL_Employee");
        this.setDatasourceLogin((Login)new DatabaseLogin());
        this.addDescriptor(this.buildChildDescriptor());
        this.addDescriptor(this.buildEmployeeDescriptor());
        this.addDescriptor(this.buildLargeProjectDescriptor());
        if (changeTracking != EmployeeSystem.ChangeTracking.ATTRIBUTE) {
            this.addDescriptor(this.buildPhoneNumberDescriptor());
        }
        this.addDescriptor(this.buildProjectDescriptor());
        this.addDescriptor(this.buildSmallProjectDescriptor());
    }

    public ClassDescriptor buildChildDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Child.class);
        descriptor.addTableName("OL_CHILD");
        descriptor.addTableName("OL_ALLOWANCE");
        descriptor.addPrimaryKeyFieldName("CHILD_ID");
        descriptor.addForeignKeyFieldNameForMultipleTable("OL_ALLOWANCE.OWNER_CHILD_ID", "OL_CHILD.CHILD_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(50);
        descriptor.setSequenceNumberFieldName("CHILD_ID");
        descriptor.setSequenceNumberName("OL_CHILD_SEQ");
        descriptor.setAlias("OL_Child");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("F_NAME");
        firstNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("L_NAME");
        lastNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)lastNameMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("CHILD_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping allowanceMapping = new DirectToFieldMapping();
        allowanceMapping.setAttributeName("allowance");
        allowanceMapping.setFieldName("OL_ALLOWANCE.ALLOWANCE");
        descriptor.addMapping((DatabaseMapping)allowanceMapping);
        return descriptor;
    }

    public ClassDescriptor buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        descriptor.addTableName("OL_EMPLOYEE");
        descriptor.addTableName("OL_SALARY");
        descriptor.addPrimaryKeyFieldName("OL_EMPLOYEE.EMP_ID");
        descriptor.addForeignKeyFieldNameForMultipleTable("OL_SALARY.OWNER_EMP_ID", "OL_EMPLOYEE.EMP_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("OL_EMP_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.setAlias("OL_Employee");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("F_NAME");
        firstNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("L_NAME");
        lastNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)lastNameMapping);
        DirectToFieldMapping salaryMapping = new DirectToFieldMapping();
        salaryMapping.setAttributeName("salary");
        salaryMapping.setFieldName("OL_SALARY.SALARY");
        descriptor.addMapping((DatabaseMapping)salaryMapping);
        DirectCollectionMapping responsibilitiesListMapping = new DirectCollectionMapping();
        responsibilitiesListMapping.setAttributeName("responsibilitiesList");
        if (this.useListOrderField) {
            if (this.useVarcharOrder) {
                responsibilitiesListMapping.setListOrderFieldName("RESPONS_ORDER_VARCHAR");
            } else {
                responsibilitiesListMapping.setListOrderFieldName("RESPONS_ORDER");
            }
            responsibilitiesListMapping.setOrderCorrectionType(this.orderCorrectionType);
        }
        if (this.useIndirection) {
            responsibilitiesListMapping.useTransparentList();
        } else {
            if (this.changeTracking == EmployeeSystem.ChangeTracking.ATTRIBUTE) {
                responsibilitiesListMapping.useCollectionClass(IndirectList.class);
            } else {
                responsibilitiesListMapping.useCollectionClass(ArrayList.class);
            }
            responsibilitiesListMapping.dontUseIndirection();
        }
        responsibilitiesListMapping.setReferenceTableName("OL_RESPONS");
        responsibilitiesListMapping.setDirectFieldName("OL_RESPONS.DESCRIP");
        responsibilitiesListMapping.addReferenceKeyFieldName("OL_RESPONS.EMP_ID", "EMP_ID");
        this.setJoinFetchOrBatchRead((ForeignReferenceMapping)responsibilitiesListMapping);
        descriptor.addMapping((DatabaseMapping)responsibilitiesListMapping);
        if (this.joinFetchOrBatchRead != EmployeeSystem.JoinFetchOrBatchRead.INNER_JOIN) {
            OneToOneMapping managerMapping = new OneToOneMapping();
            managerMapping.setAttributeName("manager");
            managerMapping.setReferenceClass(Employee.class);
            if (this.useSecondaryTable) {
                managerMapping.addForeignKeyFieldName("OL_SALARY.MANAGER_ID", "EMP_ID");
            } else {
                managerMapping.addForeignKeyFieldName("MANAGER_ID", "EMP_ID");
            }
            descriptor.addMapping((DatabaseMapping)managerMapping);
            OneToManyMapping managedEmployeesMapping = new OneToManyMapping();
            managedEmployeesMapping.setAttributeName("managedEmployees");
            managedEmployeesMapping.setReferenceClass(Employee.class);
            if (this.isPrivatelyOwned) {
                managedEmployeesMapping.privateOwnedRelationship();
            }
            if (this.useIndirection) {
                managedEmployeesMapping.useTransparentList();
            } else {
                if (this.changeTracking == EmployeeSystem.ChangeTracking.ATTRIBUTE) {
                    managedEmployeesMapping.useCollectionClass(IndirectList.class);
                } else {
                    managedEmployeesMapping.useCollectionClass(ArrayList.class);
                }
                managedEmployeesMapping.dontUseIndirection();
            }
            if (this.useListOrderField) {
                if (this.useVarcharOrder) {
                    managedEmployeesMapping.setListOrderFieldName("MANAGED_ORDER_VARCHAR");
                } else {
                    managedEmployeesMapping.setListOrderFieldName("MANAGED_ORDER");
                }
                managedEmployeesMapping.setOrderCorrectionType(this.orderCorrectionType);
            }
            if (this.useSecondaryTable) {
                managedEmployeesMapping.addTargetForeignKeyFieldName("OL_SALARY.MANAGER_ID", "EMP_ID");
            } else {
                managedEmployeesMapping.addTargetForeignKeyFieldName("MANAGER_ID", "EMP_ID");
            }
            this.setJoinFetchOrBatchRead((ForeignReferenceMapping)managedEmployeesMapping);
            descriptor.addMapping((DatabaseMapping)managedEmployeesMapping);
        }
        UnidirectionalOneToManyMapping childrenMapping = new UnidirectionalOneToManyMapping();
        childrenMapping.setAttributeName("children");
        childrenMapping.setReferenceClass(Child.class);
        if (this.isPrivatelyOwned) {
            childrenMapping.privateOwnedRelationship();
        }
        if (this.useListOrderField) {
            if (this.useVarcharOrder) {
                childrenMapping.setListOrderFieldName("CHILDREN_ORDER_VARCHAR");
            } else {
                childrenMapping.setListOrderFieldName("CHILDREN_ORDER");
            }
            childrenMapping.setOrderCorrectionType(this.orderCorrectionType);
        }
        if (this.useIndirection) {
            childrenMapping.useTransparentList();
        } else {
            if (this.changeTracking == EmployeeSystem.ChangeTracking.ATTRIBUTE) {
                childrenMapping.useCollectionClass(IndirectList.class);
            } else {
                childrenMapping.useCollectionClass(Vector.class);
            }
            childrenMapping.dontUseIndirection();
        }
        if (this.useSecondaryTable) {
            childrenMapping.addTargetForeignKeyFieldName("OL_ALLOWANCE.PARENT_ID", "EMP_ID");
        } else {
            childrenMapping.addTargetForeignKeyFieldName("OL_CHILD.PARENT_ID", "EMP_ID");
        }
        this.setJoinFetchOrBatchRead((ForeignReferenceMapping)childrenMapping);
        descriptor.addMapping((DatabaseMapping)childrenMapping);
        if (this.changeTracking != EmployeeSystem.ChangeTracking.ATTRIBUTE) {
            AggregateCollectionMapping phoneNumbersMapping = new AggregateCollectionMapping();
            phoneNumbersMapping.setAttributeName("phoneNumbers");
            phoneNumbersMapping.setReferenceClass(PhoneNumber.class);
            phoneNumbersMapping.addTargetForeignKeyFieldName("OL_PHONE.OWNER_ID", "OL_EMPLOYEE.EMP_ID");
            phoneNumbersMapping.addFieldNameTranslation("OL_PHONE.OWNER_ID", "OWNER_ID");
            phoneNumbersMapping.addFieldNameTranslation("OL_PHONE.AREA_CODE", "AREA_CODE");
            phoneNumbersMapping.addFieldNameTranslation("OL_PHONE.PNUMBER", "PNUMBER");
            phoneNumbersMapping.addFieldNameTranslation("OL_PHONE.TYPE", "TYPE");
            if (this.useListOrderField) {
                if (this.useVarcharOrder) {
                    phoneNumbersMapping.setListOrderFieldName("PHONE_ORDER_VARCHAR");
                } else {
                    phoneNumbersMapping.setListOrderFieldName("PHONE_ORDER");
                }
                phoneNumbersMapping.setOrderCorrectionType(this.orderCorrectionType);
            }
            if (this.useIndirection) {
                phoneNumbersMapping.useTransparentList();
            } else {
                if (this.changeTracking == EmployeeSystem.ChangeTracking.ATTRIBUTE) {
                    phoneNumbersMapping.useCollectionClass(IndirectList.class);
                } else {
                    phoneNumbersMapping.useCollectionClass(ArrayList.class);
                }
                phoneNumbersMapping.dontUseIndirection();
            }
            this.setJoinFetchOrBatchRead((ForeignReferenceMapping)phoneNumbersMapping);
            descriptor.addMapping((DatabaseMapping)phoneNumbersMapping);
        }
        ManyToManyMapping projectsMapping = new ManyToManyMapping();
        projectsMapping.setAttributeName("projects");
        projectsMapping.setReferenceClass(Project.class);
        if (this.isPrivatelyOwned) {
            projectsMapping.privateOwnedRelationship();
        }
        if (this.useIndirection) {
            projectsMapping.useTransparentList();
        } else {
            if (this.changeTracking == EmployeeSystem.ChangeTracking.ATTRIBUTE) {
                projectsMapping.useCollectionClass(IndirectList.class);
            } else {
                projectsMapping.useCollectionClass(ArrayList.class);
            }
            projectsMapping.dontUseIndirection();
        }
        if (this.useListOrderField) {
            if (this.useVarcharOrder) {
                projectsMapping.setListOrderFieldName("PROJ_ORDER_VARCHAR");
            } else {
                projectsMapping.setListOrderFieldName("PROJ_ORDER");
            }
            projectsMapping.setOrderCorrectionType(this.orderCorrectionType);
        }
        projectsMapping.setRelationTableName("OL_PROJ_EMP");
        projectsMapping.addSourceRelationKeyFieldName("OL_PROJ_EMP.EMP_ID", "EMP_ID");
        projectsMapping.addTargetRelationKeyFieldName("OL_PROJ_EMP.PROJ_ID", "OL_PROJECT.PROJ_ID");
        this.setJoinFetchOrBatchRead((ForeignReferenceMapping)projectsMapping);
        descriptor.addMapping((DatabaseMapping)projectsMapping);
        return descriptor;
    }

    public ClassDescriptor buildPhoneNumberDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(PhoneNumber.class);
        descriptor.addTableName("OL_AGGREGATE_PHONE");
        descriptor.descriptorIsAggregate();
        DirectToFieldMapping areaCodeMapping = new DirectToFieldMapping();
        areaCodeMapping.setAttributeName("areaCode");
        areaCodeMapping.setFieldName("AREA_CODE");
        descriptor.addMapping((DatabaseMapping)areaCodeMapping);
        DirectToFieldMapping numberMapping = new DirectToFieldMapping();
        numberMapping.setAttributeName("number");
        numberMapping.setFieldName("P_NUMBER");
        descriptor.addMapping((DatabaseMapping)numberMapping);
        DirectToFieldMapping typeMapping = new DirectToFieldMapping();
        typeMapping.setAttributeName("type");
        typeMapping.setFieldName("TYPE");
        descriptor.addMapping((DatabaseMapping)typeMapping);
        return descriptor;
    }

    public ClassDescriptor buildProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Project.class);
        descriptor.addTableName("OL_PROJECT");
        descriptor.addPrimaryKeyFieldName("OL_PROJECT.PROJ_ID");
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("PROJ_TYPE");
        descriptor.getInheritancePolicy().addClassIndicator(SmallProject.class, (Object)"S");
        descriptor.getInheritancePolicy().addClassIndicator(LargeProject.class, (Object)"L");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("PROJ_ID");
        descriptor.setSequenceNumberName("OL_PROJ_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.setAlias("OL_Project");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("DESCRIP");
        descriptionMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("PROJ_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("PROJ_NAME");
        nameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToOneMapping teamLeaderMapping = new OneToOneMapping();
        teamLeaderMapping.setAttributeName("teamLeader");
        teamLeaderMapping.setReferenceClass(Employee.class);
        teamLeaderMapping.useBasicIndirection();
        teamLeaderMapping.addForeignKeyFieldName("LEADER_ID", "OL_EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)teamLeaderMapping);
        if (!this.isPrivatelyOwned && this.joinFetchOrBatchRead == EmployeeSystem.JoinFetchOrBatchRead.NONE) {
            ManyToManyMapping employeesMapping = new ManyToManyMapping();
            employeesMapping.setAttributeName("employees");
            employeesMapping.setReferenceClass(Employee.class);
            if (this.useIndirection) {
                employeesMapping.useTransparentList();
            } else {
                if (this.changeTracking == EmployeeSystem.ChangeTracking.ATTRIBUTE) {
                    employeesMapping.useCollectionClass(IndirectList.class);
                } else {
                    employeesMapping.useCollectionClass(ArrayList.class);
                }
                employeesMapping.dontUseIndirection();
            }
            employeesMapping.readOnly();
            employeesMapping.setRelationTableName("OL_PROJ_EMP");
            employeesMapping.addSourceRelationKeyFieldName("OL_PROJ_EMP.PROJ_ID", "PROJ_ID");
            employeesMapping.addTargetRelationKeyFieldName("OL_PROJ_EMP.EMP_ID", "OL_EMPLOYEE.EMP_ID");
            descriptor.addMapping((DatabaseMapping)employeesMapping);
        }
        return descriptor;
    }

    public ClassDescriptor buildSmallProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SmallProject.class);
        descriptor.getInheritancePolicy().setParentClass(Project.class);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        descriptor.setAlias("OL_SmallProject");
        descriptor.getQueryManager().checkCacheForDoesExist();
        return descriptor;
    }

    public ClassDescriptor buildLargeProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(LargeProject.class);
        descriptor.addTableName("OL_LPROJECT");
        descriptor.getInheritancePolicy().setParentClass(Project.class);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        descriptor.setAlias("OL_LargeProject");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping budgetMapping = new DirectToFieldMapping();
        budgetMapping.setAttributeName("budget");
        budgetMapping.setFieldName("OL_LPROJECT.BUDGET");
        descriptor.addMapping((DatabaseMapping)budgetMapping);
        DirectToFieldMapping milestoneVersionMapping = new DirectToFieldMapping();
        milestoneVersionMapping.setAttributeName("milestoneVersion");
        milestoneVersionMapping.setFieldName("OL_LPROJECT.MILESTONE");
        descriptor.addMapping((DatabaseMapping)milestoneVersionMapping);
        return descriptor;
    }

    void setJoinFetchOrBatchRead(ForeignReferenceMapping mapping) {
        if (this.joinFetchOrBatchRead == EmployeeSystem.JoinFetchOrBatchRead.INNER_JOIN) {
            mapping.setJoinFetch(1);
        } else if (this.joinFetchOrBatchRead == EmployeeSystem.JoinFetchOrBatchRead.OUTER_JOIN) {
            mapping.setJoinFetch(2);
        } else if (this.joinFetchOrBatchRead == EmployeeSystem.JoinFetchOrBatchRead.BATCH_FETCH) {
            mapping.setBatchFetchType(BatchFetchType.JOIN);
        } else if (this.joinFetchOrBatchRead == EmployeeSystem.JoinFetchOrBatchRead.BATCH_IN_FETCH) {
            mapping.setBatchFetchType(BatchFetchType.IN);
        } else if (this.joinFetchOrBatchRead == EmployeeSystem.JoinFetchOrBatchRead.BATCH_EXISTS_FETCH) {
            mapping.setBatchFetchType(BatchFetchType.EXISTS);
        }
    }

    List<CollectionMapping> getListOrderMappings() {
        ArrayList<CollectionMapping> list = new ArrayList<CollectionMapping>();
        Iterator it = this.getDescriptors().values().iterator();
        while (it.hasNext()) {
            list.addAll(EmployeeProject.getListOrderMappings((ClassDescriptor)it.next()));
        }
        return list;
    }

    static List<CollectionMapping> getListOrderMappings(DatabaseSession session) {
        ArrayList<CollectionMapping> list = new ArrayList<CollectionMapping>();
        list.addAll(EmployeeProject.getListOrderMappings(session.getDescriptor(Employee.class)));
        list.addAll(EmployeeProject.getListOrderMappings(session.getDescriptor(Project.class)));
        return list;
    }

    static List<CollectionMapping> getListOrderMappings(ClassDescriptor desc) {
        ArrayList<CollectionMapping> list = new ArrayList<CollectionMapping>();
        Vector mappings = desc.getMappings();
        for (int i = 0; i < mappings.size(); ++i) {
            CollectionMapping collectionMapping;
            if (!((DatabaseMapping)mappings.get(i)).isCollectionMapping() || (collectionMapping = (CollectionMapping)mappings.get(i)).getListOrderField() == null) continue;
            list.add(collectionMapping);
        }
        return list;
    }
}

