/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import java.util.Vector;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.mapping.Peripheral;

public class ObjectTypeMappingBooleanToCharTest
extends TransactionalTestCase {
    protected Vector<Peripheral> peripheralsRead;

    public ObjectTypeMappingBooleanToCharTest() {
        this.setDescription("Read Boolean->Character ObjectTypeMapping in additionalJoinCriteria");
    }

    public void setup() {
        super.setup();
        UnitOfWorkImpl uow = this.getAbstractSession().acquireUnitOfWork();
        Peripheral peripheral1 = (Peripheral)uow.registerObject((Object)new Peripheral(1L));
        peripheral1.setName("peripheral-1");
        peripheral1.setValid(true);
        Peripheral peripheral2 = (Peripheral)uow.registerObject((Object)new Peripheral(2L));
        peripheral2.setName("peripheral-2");
        peripheral2.setValid(false);
        uow.commit();
    }

    public void test() {
        this.peripheralsRead = this.getAbstractSession().readAllObjects(Peripheral.class);
    }

    public void verify() {
        ObjectTypeMappingBooleanToCharTest.assertNotNull((String)"peripheralsRead should not be null", this.peripheralsRead);
        ObjectTypeMappingBooleanToCharTest.assertEquals((String)"One Peripheral object should have been read", (int)1, (int)this.peripheralsRead.size());
    }

    public void reset() {
        super.reset();
        this.peripheralsRead = null;
    }
}

