/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.relationships;

import jakarta.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.relationships.Customer;
import org.eclipse.persistence.testing.models.jpa.relationships.CustomerCollection;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsTableManager;

public class UniAndBiDirectionalMappingTestSuite
extends JUnitTestCase {
    public UniAndBiDirectionalMappingTestSuite() {
    }

    public UniAndBiDirectionalMappingTestSuite(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        new RelationshipsTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("UniAndBiDirectionalMappingTestSuite");
        suite.addTest((Test)new UniAndBiDirectionalMappingTestSuite("selfReferencingManyToManyCreateTest"));
        suite.addTest((Test)new UniAndBiDirectionalMappingTestSuite("testManyToManyClearDelete"));
        return suite;
    }

    public void selfReferencingManyToManyCreateTest() throws Exception {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Customer owen = new Customer();
        owen.setName("Owen Pelletier");
        owen.setCity("Ottawa");
        em.persist((Object)owen);
        int owenId = owen.getCustomerId();
        Customer kirty = new Customer();
        kirty.setName("Kirsten Pelletier");
        kirty.setCity("Ottawa");
        kirty.addCCustomer(owen);
        em.persist((Object)kirty);
        int kirtyId = kirty.getCustomerId();
        Customer guy = new Customer();
        guy.setName("Guy Pelletier");
        guy.setCity("Ottawa");
        guy.addCCustomer(owen);
        guy.addCCustomer(kirty);
        kirty.addCCustomer(guy);
        em.persist((Object)guy);
        int guyId = guy.getCustomerId();
        this.commitTransaction(em);
        this.clearCache();
        Customer newOwen = (Customer)em.find(Customer.class, (Object)owenId);
        Customer newKirty = (Customer)em.find(Customer.class, (Object)kirtyId);
        Customer newGuy = (Customer)em.find(Customer.class, (Object)guyId);
        UniAndBiDirectionalMappingTestSuite.assertTrue((String)"Owen has controlled customers .", (boolean)newOwen.getCCustomers().isEmpty());
        UniAndBiDirectionalMappingTestSuite.assertFalse((String)"Kirty did not have any controlled customers.", (boolean)newKirty.getCCustomers().isEmpty());
        UniAndBiDirectionalMappingTestSuite.assertFalse((String)"Guy did not have any controlled customers.", (boolean)newGuy.getCCustomers().isEmpty());
        this.closeEntityManager(em);
    }

    public void testManyToManyClearDelete() throws Exception {
        EntityManager entityManager = this.createEntityManager();
        this.beginTransaction(entityManager);
        Customer owen = new Customer();
        owen.setName("Owen Pelletier");
        owen.setCity("Ottawa");
        entityManager.persist((Object)owen);
        int owenId = owen.getCustomerId();
        Customer kirty = new Customer();
        kirty.setName("Kirsten Pelletier");
        kirty.setCity("Ottawa");
        kirty.addCCustomer(owen);
        entityManager.persist((Object)kirty);
        int kirtyId = kirty.getCustomerId();
        owen.addCCustomer(kirty);
        this.commitTransaction(entityManager);
        this.beginTransaction(entityManager);
        owen = (Customer)entityManager.find(Customer.class, (Object)owenId);
        kirty = (Customer)entityManager.find(Customer.class, (Object)kirtyId);
        owen.setCCustomers(new CustomerCollection());
        kirty.setCCustomers(new CustomerCollection());
        entityManager.merge((Object)owen);
        entityManager.merge((Object)kirty);
        entityManager.remove((Object)owen);
        entityManager.remove((Object)kirty);
        this.commitTransaction(entityManager);
        this.closeEntityManager(entityManager);
    }
}

