/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.criteria;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;

public class AdvancedQueryTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public AdvancedQueryTestSuite() {
    }

    public AdvancedQueryTestSuite(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AdvancedQueryTestSuite");
        suite.addTest((Test)new AdvancedQueryTestSuite("testSetup"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryCacheFirstCacheHits"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryCacheOnlyCacheHits"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryCacheOnlyCacheHitsOnSession"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryExactPrimaryKeyCacheHits"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testObjectResultType"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testCursors"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUntypedPath() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            CriteriaQuery empCQ = qb.createQuery(Employee.class);
            Root from = empCQ.from(Employee.class);
            Join join = from.join("address");
            empCQ.where((Expression)qb.greaterThanOrEqualTo(from.get("id").as(Integer.class), qb.literal((Object)5)));
            query = em.createQuery(empCQ);
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheByExactPrimaryKey");
            query.setParameter("id", (Object)employee.getId());
            Employee queryResult = (Employee)query.getSingleResult();
            if (queryResult != employee) {
                AdvancedQueryTestSuite.fail((String)("Employees are not equal: " + employee + ", " + queryResult));
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTupleQuery() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            TypedQuery query = em.createQuery(em.getCriteriaBuilder().createQuery(Employee.class));
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            CriteriaQuery cq = qb.createQuery(Tuple.class);
            Root from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.get("id"), from.get("firstName")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            TypedQuery typedQuery = em.createQuery(cq);
            typedQuery.setParameter("id", (Object)employee.getId());
            typedQuery.setParameter("firstName", (Object)employee.getFirstName());
            Tuple queryResult = (Tuple)typedQuery.getSingleResult();
            AdvancedQueryTestSuite.assertTrue((String)"Query Results do not match selection", (queryResult.get(0).equals(employee.getId()) && queryResult.get(1).equals(employee.getFirstName()) ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCursors() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            TypedQuery query = em.createQuery(em.getCriteriaBuilder().createQuery(Employee.class));
            query.setHint("eclipselink.cursor", (Object)true);
            query.setHint("eclipselink.cursor.initial-size", (Object)2);
            query.setHint("eclipselink.cursor.page-size", (Object)5);
            query.setHint("eclipselink.cursor.size-sql", (Object)"Select count(*) from CMP3_EMPLOYEE");
            Cursor cursor = (Cursor)query.getSingleResult();
            cursor.nextElement();
            cursor.size();
            cursor.close();
            JpaQuery jpaQuery = (JpaQuery)((EntityManager)em.getDelegate()).createQuery(em.getCriteriaBuilder().createQuery(Employee.class));
            jpaQuery.setHint("eclipselink.cursor", (Object)true);
            cursor = jpaQuery.getResultCursor();
            cursor.nextElement();
            cursor.size();
            cursor.close();
            jpaQuery = (JpaQuery)((EntityManager)em.getDelegate()).createQuery(em.getCriteriaBuilder().createQuery(Employee.class));
            jpaQuery.setHint("eclipselink.cursor.scrollable", (Object)true);
            jpaQuery.setHint("eclipselink.cursor.scrollable.result-set-concurrency", (Object)"ReadOnly");
            String resultSetType = "ScrollInsensitive";
            if (this.getPlatform().isHANA()) {
                resultSetType = "ForwardOnly";
            }
            jpaQuery.setHint("eclipselink.cursor.scrollable.result-set-type", (Object)resultSetType);
            ScrollableCursor scrollableCursor = (ScrollableCursor)jpaQuery.getResultCursor();
            scrollableCursor.next();
            scrollableCursor.close();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObjectResultType() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            List listResult;
            TypedQuery query = em.createQuery(em.getCriteriaBuilder().createQuery(Employee.class));
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Object[].class);
            Root from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from, from.get("address"), from.get("id")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            Object[] arrayResult = (Object[])query.getSingleResult();
            if (arrayResult.length != 3 && arrayResult[0] != employee || arrayResult[1] != employee.getAddress() || !arrayResult[2].equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            if ((arrayResult = (Object[])(listResult = query.getResultList()).get(0)).length != 3 || arrayResult[0] != employee || arrayResult[1] != employee.getAddress() || !arrayResult[2].equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            cq = qb.createQuery(Object[].class);
            from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.get("id")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setHint("eclipselink.result-type", (Object)"Array");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            arrayResult = (Object[])query.getSingleResult();
            if (arrayResult.length != 1 || !arrayResult[0].equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            if ((arrayResult = (Object[])(listResult = query.getResultList()).get(0)).length != 1 || !arrayResult[0].equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            cq = qb.createQuery(Object[].class);
            from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.alias("employee"), from.get("address").alias("address"), from.get("id").alias("id")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setHint("eclipselink.result-type", (Object)"Map");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            Map mapResult = (Map)query.getSingleResult();
            if (mapResult.size() != 3 || mapResult.get("employee") != employee || mapResult.get("address") != employee.getAddress() || !mapResult.get("id").equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            if ((mapResult = (Map)(listResult = query.getResultList()).get(0)).size() != 3 || mapResult.get("employee") != employee || mapResult.get("address") != employee.getAddress() || !mapResult.get("id").equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            cq = qb.createQuery(Object[].class);
            from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.get("id").alias("id")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setHint("eclipselink.result-type", (Object)"Map");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            mapResult = (Map)query.getSingleResult();
            if (mapResult.size() != 1 || !mapResult.get("id").equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            if ((mapResult = (Map)(listResult = query.getResultList()).get(0)).size() != 1 || !mapResult.get("id").equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            cq = qb.createQuery(Employee.class);
            from = cq.from(Employee.class);
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setHint("eclipselink.query-type", (Object)"Report");
            query.setHint("eclipselink.result-type", (Object)"Array");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            arrayResult = (Object[])query.getSingleResult();
            if (arrayResult[0] != employee) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            cq = qb.createQuery(Object[].class);
            from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.get("id")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            Object valueResult = query.getSingleResult();
            if (!valueResult.equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            if (!(valueResult = (listResult = query.getResultList()).get(0)).equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            cq = qb.createQuery(Object[].class);
            from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.get("id"), from.get("firstName")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setHint("eclipselink.result-type", (Object)"Value");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            valueResult = query.getSingleResult();
            if (!valueResult.equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            cq = qb.createQuery(Object[].class);
            from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.get("id")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setHint("eclipselink.result-type", (Object)"Attribute");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            valueResult = query.getSingleResult();
            if (!valueResult.equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            if (!(valueResult = (listResult = query.getResultList()).get(0)).equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryExactPrimaryKeyCacheHits() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            cq = qb.createQuery(Employee.class);
            Root from = cq.from(Employee.class);
            cq.where((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")));
            query = em.createQuery(cq);
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheByExactPrimaryKey");
            query.setParameter("id", (Object)employee.getId());
            Employee queryResult = (Employee)query.getSingleResult();
            if (queryResult != employee) {
                AdvancedQueryTestSuite.fail((String)("Employees are not equal: " + employee + ", " + queryResult));
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCacheFirstCacheHits() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            Employee employee = (Employee)result.get(result.size() - 1);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            cq = qb.createQuery(Employee.class);
            Root from = cq.from(Employee.class);
            cq.where((Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName")));
            query = em.createQuery(cq);
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheThenDatabase");
            query.setParameter("firstName", (Object)employee.getFirstName());
            Employee queryResult = (Employee)query.getSingleResult();
            if (!queryResult.getFirstName().equals(employee.getFirstName())) {
                AdvancedQueryTestSuite.fail((String)("Employees are not equal: " + employee + ", " + queryResult));
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCacheOnlyCacheHits() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            Employee employee = (Employee)result.get(result.size() - 1);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            cq = qb.createQuery(Employee.class);
            Root from = cq.from(Employee.class);
            cq.where((Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName")));
            query = em.createQuery(cq);
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheOnly");
            query.setParameter("firstName", (Object)employee.getFirstName());
            query.getResultList();
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCacheOnlyCacheHitsOnSession() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            Employee employee = (Employee)result.get(result.size() - 1);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            cq = qb.createQuery(Employee.class);
            Root from = cq.from(Employee.class);
            cq.where((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")));
            query = em.createQuery(cq);
            query.setHint("eclipselink.query-type", (Object)"ReadObject");
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheOnly");
            query.setParameter("id", (Object)employee.getId());
            if (query.getSingleResult() == null) {
                AdvancedQueryTestSuite.fail((String)"Query did not check session cache.");
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            cq = qb.createQuery(Employee.class);
            from = cq.from(Employee.class);
            cq.where((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")));
            query = em.createQuery(cq);
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheOnly");
            query.setParameter("id", (Object)employee.getId());
            if (query.getResultList().size() != 1) {
                AdvancedQueryTestSuite.fail((String)"Query did not check session cache.");
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }
}

