/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.validation.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class NestedUOWWithUpdateAllQueryTest
extends ExceptionTest {
    public NestedUOWWithUpdateAllQueryTest() {
        this.setDescription("This test tests that you cannot execute an update all query within a nested UOW.");
    }

    @Override
    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        super.reset();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
        this.expectedException = ValidationException.nestedUOWNotSupportedForModifyAllQuery();
    }

    public void test() {
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        UnitOfWork uow2 = uow1.acquireUnitOfWork();
        ExpressionBuilder eb = new ExpressionBuilder();
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
        updateQuery.addUpdate(eb.get("lastName"), (Object)"dummyLastName");
        try {
            uow2.executeQuery((DatabaseQuery)updateQuery);
        }
        catch (EclipseLinkException e) {
            this.caughtException = e;
        }
    }
}

