/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableCacheSyncDistributedTest;

public class InvalidateObjectWithMissingReferenceTest
extends ConfigurableCacheSyncDistributedTest {
    ReadObjectQuery query;
    Employee originalObject;
    Address originalAddress;
    Address newAddress;
    DistributedServer server;

    public InvalidateObjectWithMissingReferenceTest() {
        this.setName("InvalidateObjectWithMissingReferenceTest");
        this.cacheSyncConfigValues.put(Employee.class, 1);
        this.cacheSyncConfigValues.put(Address.class, 4);
    }

    @Override
    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        Enumeration enumtr = DistributedServersModel.getDistributedServers().elements();
        while (enumtr.hasMoreElements()) {
            ((DistributedServer)enumtr.nextElement()).getDistributedSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        Enumeration keys = this.oldCacheSyncConfigValues.keys();
        while (keys.hasMoreElements()) {
            Class keyClass = (Class)keys.nextElement();
            ClassDescriptor descriptor = this.getSession().getDescriptor(keyClass);
            int newCacheSyncType = (Integer)this.oldCacheSyncConfigValues.get(keyClass);
            descriptor.setCacheSynchronizationType(newCacheSyncType);
        }
    }

    @Override
    public void setup() {
        this.oldCacheSyncConfigValues = new Hashtable();
        Enumeration keys = this.cacheSyncConfigValues.keys();
        while (keys.hasMoreElements()) {
            Class keyClass = (Class)keys.nextElement();
            ClassDescriptor descriptor = this.getSession().getDescriptor(keyClass);
            if (descriptor == null) continue;
            int cacheSyncType = descriptor.getCacheSynchronizationType();
            Object newCacheSyncType = this.cacheSyncConfigValues.get(keyClass);
            if (newCacheSyncType == null) continue;
            this.oldCacheSyncConfigValues.put(keyClass, cacheSyncType);
            descriptor.setCacheSynchronizationType(((Integer)newCacheSyncType).intValue());
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.originalObject = (Employee)this.getSession().readObject(Employee.class);
        this.originalAddress = this.originalObject.getAddress();
        this.query = new ReadObjectQuery();
        this.query.setSelectionObject((Object)this.originalObject);
        this.server = (DistributedServer)DistributedServersModel.getDistributedServers().get(0);
        this.getEmployeeFromDistributedSession((DatabaseQuery)this.query);
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee empClone = (Employee)uow.registerObject((Object)this.originalObject);
        this.newAddress = new Address();
        this.newAddress.setCity("Ottawa");
        this.newAddress.setPostalCode("K5J2B5");
        this.newAddress.setProvince("ONT");
        this.newAddress.setStreet("should not exist when test completes");
        this.newAddress.setCountry("Canada");
        Address addressClone = (Address)uow.registerObject((Object)this.newAddress);
        empClone.setAddress(addressClone);
        uow.assignSequenceNumber((Object)addressClone);
        ((UnitOfWorkImpl)uow).issueSQLbeforeCompletion();
        this.getAbstractSession().insertObject((Object)this.originalAddress);
        this.getAbstractSession().getSessionForClass(Employee.class).executeNonSelectingSQL("UPDATE EMPLOYEE SET ADDR_ID = " + this.originalAddress.getId() + " WHERE (EMP_ID = " + empClone.getId() + ")");
        this.getAbstractSession().deleteObject((Object)addressClone);
        ((UnitOfWorkImpl)uow).mergeClonesAfterCompletion();
    }

    protected void verify() {
        Employee remoteEmployee = (Employee)this.getObjectFromDistributedCache(this.originalObject);
        if (remoteEmployee != null && remoteEmployee.getAddress() == null) {
            throw new TestErrorException("Employee's Address reference was corrupted during RCM synch when Address was removed from the database. ");
        }
        remoteEmployee = this.getEmployeeFromDistributedSession((DatabaseQuery)this.query);
        if (remoteEmployee.getAddress() == null) {
            throw new TestErrorException("Employee's Address reference was corrupted during RCM synch when Address was removed from the database. ");
        }
        if (remoteEmployee.getAddress().getId() == this.newAddress.getId()) {
            throw new TestErrorException("New object Address was built/sent with the changeset in RCM though its descriptor specifies DO_NOT_SEND_CHANGES");
        }
    }

    public Employee getEmployeeFromDistributedSession(DatabaseQuery query) {
        try {
            Employee result = (Employee)this.server.getDistributedSession().executeQuery(query);
            result.getAddress();
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

