/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Iterator;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.ownership.ObjectA;
import org.eclipse.persistence.testing.tests.mapping.BiDirectionInsertOrderTest;
import org.eclipse.persistence.testing.tests.mapping.EqualObjectUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.AllChangeSetsTest;
import org.eclipse.persistence.testing.tests.unitofwork.BuildCloneFromRowOneToOneTest;
import org.eclipse.persistence.testing.tests.unitofwork.CanChangeReadOnlySetTest;
import org.eclipse.persistence.testing.tests.unitofwork.CloneAttributeIfMutableTest;
import org.eclipse.persistence.testing.tests.unitofwork.CollectionMappingMergeObjectTest;
import org.eclipse.persistence.testing.tests.unitofwork.CommitAfterExecuteModifyQueryDuringTransTest;
import org.eclipse.persistence.testing.tests.unitofwork.ComplexMultipleUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.CreateDeleteCreateTest;
import org.eclipse.persistence.testing.tests.unitofwork.CurrentChangeSetTest;
import org.eclipse.persistence.testing.tests.unitofwork.DeepMergeCloneIndirectionTest;
import org.eclipse.persistence.testing.tests.unitofwork.DeepMergeCloneSerializedTest;
import org.eclipse.persistence.testing.tests.unitofwork.DeepNestedUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.DeleteAndConform;
import org.eclipse.persistence.testing.tests.unitofwork.DeletingFromParentSessionTest;
import org.eclipse.persistence.testing.tests.unitofwork.DoubleNestedUnitOfWorkDeleteConformedNestedNewObjectTest;
import org.eclipse.persistence.testing.tests.unitofwork.DoubleNestedUnitOfWorkRegisterNewObjectTest;
import org.eclipse.persistence.testing.tests.unitofwork.ErrorOnInsertTest;
import org.eclipse.persistence.testing.tests.unitofwork.ExceptionsRaisedUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.FaultyUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.GetFromNewObjectWithConformTest;
import org.eclipse.persistence.testing.tests.unitofwork.GetIdentityMapFromUOWForREADONLYClassTest;
import org.eclipse.persistence.testing.tests.unitofwork.GetObjectFromIdentityMapTest;
import org.eclipse.persistence.testing.tests.unitofwork.InsertNewObjectTest;
import org.eclipse.persistence.testing.tests.unitofwork.LockFailureUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.MergeCloneWithReferencesTransparentIndirectionTest;
import org.eclipse.persistence.testing.tests.unitofwork.MergeCloneWithReferencesWithNullTest;
import org.eclipse.persistence.testing.tests.unitofwork.MergeDeadIndirectionTest;
import org.eclipse.persistence.testing.tests.unitofwork.MergeUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.MultipleUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.NestedUOWWithNewObjectRegisteredTwiceTest;
import org.eclipse.persistence.testing.tests.unitofwork.NestedUnitOfWorkDeleteConformedNestedNewObjectTest;
import org.eclipse.persistence.testing.tests.unitofwork.NestedUnitOfWorkDeleteNestedNewObjectTest;
import org.eclipse.persistence.testing.tests.unitofwork.NestedUnitOfWorkDeleteNewObjectTest;
import org.eclipse.persistence.testing.tests.unitofwork.NestedUnitOfWorkMultipleCommitTest;
import org.eclipse.persistence.testing.tests.unitofwork.NestedUnitOfWorkNewObjectWithIndirectionTest;
import org.eclipse.persistence.testing.tests.unitofwork.NestedUnitOfWorkQuery;
import org.eclipse.persistence.testing.tests.unitofwork.NestedUnitOfWorkReadOnlyClassTest;
import org.eclipse.persistence.testing.tests.unitofwork.NestedUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.NoIMWithValueHolderTest;
import org.eclipse.persistence.testing.tests.unitofwork.NoIdentityMapUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.NoIdentityMergeCloneTest;
import org.eclipse.persistence.testing.tests.unitofwork.NoIdentityTest;
import org.eclipse.persistence.testing.tests.unitofwork.NoValidationWithInitIdentityMaps;
import org.eclipse.persistence.testing.tests.unitofwork.NullAggregateTest;
import org.eclipse.persistence.testing.tests.unitofwork.PerformDeletesFirstIgnoreUpdateTest;
import org.eclipse.persistence.testing.tests.unitofwork.PerformDeletesFirstIgnoreUpdateTest2;
import org.eclipse.persistence.testing.tests.unitofwork.PerformDeletesFirstTest;
import org.eclipse.persistence.testing.tests.unitofwork.RefreshObjectNoIdentityMapUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.RegisterNewObjectInIdentityMapNoSeqTest;
import org.eclipse.persistence.testing.tests.unitofwork.RegisterNewObjectTest;
import org.eclipse.persistence.testing.tests.unitofwork.RegisterationUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.RelationshipTreeInsertTest;
import org.eclipse.persistence.testing.tests.unitofwork.UOWCommitAndResumeWithPreCalcChangeSet;
import org.eclipse.persistence.testing.tests.unitofwork.UOWHasOnlyDeletesTest;
import org.eclipse.persistence.testing.tests.unitofwork.UOWPrimaryKeyToNewObjectsDuplicateObjectsTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkCommitAndResume;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkCommitResumeOnFailureNoFailureTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkCommitToDatabaseTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkComplexRefreshTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkDeleteNoValidationTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkExistingObjectsListTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkInitializeAllIdentityMapsTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkNullPrimaryKeyTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkResumeOnFailureTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkResumeTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkRevertAndResumeWithNewTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkRevertTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkRevertWithNewObjectTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnregisterUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnregisteredNewObjectOptimisticLockTest;
import org.eclipse.persistence.testing.tests.unitofwork.ViolateObjectSpaceTest;
import org.eclipse.persistence.testing.tests.unitofwork.WasTransactionBegunPrematurelyRollbackTest;
import org.eclipse.persistence.testing.tests.unitofwork.WorkingCloneCopyPolicyTest;
import org.eclipse.persistence.testing.tests.writing.BidirectionalInsertTest;
import org.eclipse.persistence.testing.tests.writing.ComplexUpdateTest;
import org.eclipse.persistence.testing.tests.writing.UpdateChangeNothingTest;
import org.eclipse.persistence.testing.tests.writing.UpdateChangeObjectTest;
import org.eclipse.persistence.testing.tests.writing.UpdateChangeValueTest;
import org.eclipse.persistence.testing.tests.writing.UpdateDeepOwnershipTest;
import org.eclipse.persistence.testing.tests.writing.UpdateToNullTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class UnitOfWorkTestSuite
extends TestSuite {
    public UnitOfWorkTestSuite() {
        this.setDescription("This suite tests updating objects with changed parts.");
    }

    public UnitOfWorkTestSuite(boolean isSRG) {
        super(isSRG);
        this.setDescription("This suite tests updating objects with changed parts.");
    }

    public void addTests() {
        this.addTest((Test)new MergeCloneWithReferencesWithNullTest());
        this.addTest((Test)new MergeCloneWithReferencesTransparentIndirectionTest());
        this.addTest((Test)new UnitOfWorkRevertAndResumeWithNewTest());
        this.addTest((Test)new UnitOfWorkRevertWithNewObjectTest());
        this.addTest((Test)new UnitOfWorkNullPrimaryKeyTest());
        this.addTest((Test)new UnitOfWorkExistingObjectsListTest());
        this.addTest((Test)new MergeUnitOfWorkTest(PopulationManager.getDefaultManager().getObject(Employee.class, "0001")));
        this.addTest((Test)new RegisterationUnitOfWorkTest(PopulationManager.getDefaultManager().getObject(Employee.class, "0001")));
        this.addTest((Test)this.buildRefreshDeletedObjectTest());
        this.addTest((Test)new UnregisterUnitOfWorkTest());
        this.addTest((Test)new UOWPrimaryKeyToNewObjectsDuplicateObjectsTest());
        this.addTest((Test)new CloneAttributeIfMutableTest());
        this.addSRGTests();
        this.addTest((Test)this.buildRefReadOnlyTest());
        this.addTest((Test)new BuildCloneFromRowOneToOneTest());
        this.addTest((Test)this.buildCacheIndexTest());
    }

    public void addSRGTests() {
        PopulationManager manager = PopulationManager.getDefaultManager();
        Employee employee = (Employee)manager.getObject(Employee.class, "0001");
        ComplexUpdateTest test = new UpdateToNullTest(employee);
        test.usesUnitOfWork = true;
        this.addTest((Test)test);
        test = new UpdateChangeValueTest(employee);
        test.usesUnitOfWork = true;
        this.addTest((Test)test);
        test = new UpdateChangeNothingTest(employee);
        test.usesUnitOfWork = true;
        this.addTest((Test)test);
        test = new UpdateChangeObjectTest(employee);
        test.usesUnitOfWork = true;
        this.addTest((Test)test);
        test = new UpdateDeepOwnershipTest((ObjectA)manager.getObject(ObjectA.class, "example1"));
        test.usesUnitOfWork = true;
        this.addTest((Test)test);
        this.addTest((Test)new BidirectionalInsertTest(true));
        this.addTest((Test)new NestedUnitOfWorkTest(employee));
        this.addTest((Test)new NestedUnitOfWorkMultipleCommitTest(employee));
        this.addTest((Test)new DeepNestedUnitOfWorkTest(employee));
        this.addTest((Test)new MultipleUnitOfWorkTest(employee));
        this.addTest((Test)new InsertNewObjectTest());
        this.addTest((Test)new ComplexMultipleUnitOfWorkTest());
        this.addTest((Test)new FaultyUnitOfWorkTest());
        this.addTest((Test)new LockFailureUnitOfWorkTest());
        this.addTest((Test)new UnitOfWorkResumeTest(employee));
        this.addTest((Test)new UnitOfWorkResumeOnFailureTest(employee));
        this.addTest((Test)new DeletingFromParentSessionTest());
        this.addTest((Test)new EqualObjectUnitOfWorkTest());
        this.addTest((Test)new NoIMWithValueHolderTest());
        this.addTest((Test)new UnitOfWorkRevertTest(employee));
        this.addTest((Test)new DeepMergeCloneSerializedTest());
        this.addTest((Test)new DeepMergeCloneIndirectionTest());
        this.addTest((Test)new RegisterNewObjectTest());
        this.addTest((Test)new NoIdentityMapUnitOfWorkTest());
        this.addTest((Test)new RefreshObjectNoIdentityMapUnitOfWorkTest());
        this.addTest((Test)new RelationshipTreeInsertTest());
        this.addTest((Test)new UnitOfWorkComplexRefreshTest());
        this.addTest((Test)new ViolateObjectSpaceTest());
        this.addTest((Test)new NoValidationWithInitIdentityMaps());
        this.addTest((Test)new NoIdentityTest());
        this.addTest((Test)new NoIdentityMergeCloneTest());
        this.addTest((Test)new BiDirectionInsertOrderTest());
        this.addTest((Test)new UnitOfWorkCommitResumeOnFailureNoFailureTest(employee));
        this.addTest((Test)new UnitOfWorkCommitAndResume(employee));
        this.addTest((Test)new NestedUnitOfWorkQuery());
        this.addTest((Test)new DeleteAndConform());
        this.addTest((Test)new NullAggregateTest());
        this.addTest((Test)new UOWHasOnlyDeletesTest());
        this.addTest((Test)new RegisterNewObjectInIdentityMapNoSeqTest(IdValidation.NULL, false, false));
        this.addTest((Test)new RegisterNewObjectInIdentityMapNoSeqTest(IdValidation.ZERO, false, false));
        this.addTest((Test)new RegisterNewObjectInIdentityMapNoSeqTest(IdValidation.NEGATIVE, false, false));
        this.addTest((Test)new RegisterNewObjectInIdentityMapNoSeqTest(IdValidation.NULL, true, false));
        this.addTest((Test)new RegisterNewObjectInIdentityMapNoSeqTest(IdValidation.ZERO, true, false));
        this.addTest((Test)new RegisterNewObjectInIdentityMapNoSeqTest(IdValidation.NEGATIVE, true, false));
        this.addTest((Test)new RegisterNewObjectInIdentityMapNoSeqTest(IdValidation.NULL, true, true));
        this.addTest((Test)new RegisterNewObjectInIdentityMapNoSeqTest(IdValidation.ZERO, true, true));
        this.addTest((Test)new RegisterNewObjectInIdentityMapNoSeqTest(IdValidation.NEGATIVE, true, true));
        this.addTest((Test)new NestedUnitOfWorkDeleteNewObjectTest());
        this.addTest((Test)new NestedUnitOfWorkDeleteNestedNewObjectTest());
        this.addTest((Test)new NestedUnitOfWorkDeleteConformedNestedNewObjectTest());
        this.addTest((Test)new DoubleNestedUnitOfWorkDeleteConformedNestedNewObjectTest());
        this.addTest((Test)new NestedUnitOfWorkNewObjectWithIndirectionTest());
        this.addTest((Test)new UnitOfWorkDeleteNoValidationTest());
        this.addTest((Test)new GetIdentityMapFromUOWForREADONLYClassTest());
        this.addTest((Test)new UnitOfWorkCommitToDatabaseTest());
        this.addTest((Test)new UnitOfWorkInitializeAllIdentityMapsTest());
        this.addTest((Test)new WasTransactionBegunPrematurelyRollbackTest());
        this.addTest((Test)new CanChangeReadOnlySetTest());
        this.addTest((Test)new GetFromNewObjectWithConformTest());
        this.addTest((Test)new UOWCommitAndResumeWithPreCalcChangeSet(employee));
        this.addTest((Test)new PerformDeletesFirstTest());
        this.addTest((Test)new PerformDeletesFirstIgnoreUpdateTest());
        this.addTest((Test)new PerformDeletesFirstIgnoreUpdateTest2());
        this.addTest((Test)new CreateDeleteCreateTest());
        this.addTest((Test)new WorkingCloneCopyPolicyTest());
        this.addTest((Test)new UnregisteredNewObjectOptimisticLockTest());
        this.addTest((Test)new DoubleNestedUnitOfWorkRegisterNewObjectTest());
        this.addTest((Test)new GetObjectFromIdentityMapTest());
        this.addTest((Test)new MergeDeadIndirectionTest());
        this.addTest((Test)new CommitAfterExecuteModifyQueryDuringTransTest());
        this.addTest((Test)new AllChangeSetsTest());
        this.addTest((Test)new CurrentChangeSetTest());
        this.addTest((Test)new ErrorOnInsertTest());
        this.addTest((Test)new CollectionMappingMergeObjectTest());
        this.addTest((Test)new ExceptionsRaisedUnitOfWorkTest());
        this.addTest((Test)new NestedUOWWithNewObjectRegisteredTwiceTest());
        this.addTest((Test)new NestedUnitOfWorkReadOnlyClassTest());
    }

    public TransactionalTestCase buildRefreshDeletedObjectTest() {
        TransactionalTestCase test = new TransactionalTestCase(){

            public void test() {
                Vector employees = this.getSession().readAllObjects(Employee.class);
                Employee employee = null;
                Iterator iterator = employees.iterator();
                while (iterator.hasNext() && (employee = (Employee)iterator.next()).getPhoneNumbers().size() <= 0) {
                }
                UnitOfWork uow = this.getSession().acquireUnitOfWork();
                uow.deleteObject(employee.getPhoneNumbers().get(0));
                uow.commit();
                this.getSession().getIdentityMapAccessor().invalidateClass(PhoneNumber.class);
                uow = this.getSession().acquireUnitOfWork();
                employee = (Employee)uow.readObject((Object)employee);
                employee.getPhoneNumbers().get(0);
                uow.commit();
            }
        };
        test.setName("RefreshDeletedObjectTest");
        test.setDescription("Test issue of loss of identity causing loop in cloning with invalidation.");
        return test;
    }

    public TransactionalTestCase buildRefReadOnlyTest() {
        TransactionalTestCase test = new TransactionalTestCase(){

            public void setup() {
                super.setup();
                if (this.getSession().isRemoteSession()) {
                    this.throwWarning("Test not supported on remote session.");
                }
                this.getSession().getDescriptor(Address.class).setReadOnly();
            }

            public void test() {
                UnitOfWork uow = this.getSession().acquireUnitOfWork();
                Address address = (Address)uow.readObject(Address.class);
                Employee employee = new Employee();
                employee = (Employee)uow.registerObject((Object)employee);
                employee.setAddress(address);
                uow.commit();
            }

            public void reset() {
                super.reset();
                this.getSession().getDescriptor(Address.class).setShouldBeReadOnly(false);
            }
        };
        test.setName("RefReadOnlyTest");
        test.setDescription("Tests saving a new object with a reference to a read-only object.");
        return test;
    }

    public TransactionalTestCase buildCacheIndexTest() {
        TransactionalTestCase test = new TransactionalTestCase(){

            public void setup() {
                super.setup();
                if (this.getSession().isRemoteSession()) {
                    this.throwWarning("Test not supported on remote session.");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test() {
                QuerySQLTracker counter = new QuerySQLTracker(this.getSession());
                try {
                    ReadObjectQuery query = new ReadObjectQuery(Employee.class);
                    ExpressionBuilder emp = new ExpressionBuilder();
                    query.setSelectionCriteria(emp.get("firstName").equal((Object)"cache").and(emp.get("lastName").equal((Object)"index")));
                    UnitOfWork uow = this.getSession().acquireUnitOfWork();
                    Employee employee = new Employee();
                    employee.setFirstName("cache");
                    employee.setLastName("index");
                    employee = (Employee)uow.registerObject((Object)employee);
                    if (uow.executeQuery((DatabaseQuery)query) != null) {
                        this.throwError("New employee should not have been found.");
                    }
                    if (counter.getSqlStatements().size() == 0) {
                        this.throwError("Query should have hit database.");
                    }
                    uow.commit();
                    counter.getSqlStatements().clear();
                    if (uow.executeQuery((DatabaseQuery)query) != employee) {
                        this.throwError("New employee should have been found.");
                    }
                    if (counter.getSqlStatements().size() > 0) {
                        this.throwError("Query should have hit cache.");
                    }
                    uow = this.getSession().acquireUnitOfWork();
                    employee = (Employee)uow.registerObject((Object)employee);
                    employee.setLastName("fail");
                    uow.commit();
                    counter.getSqlStatements().clear();
                    if (uow.executeQuery((DatabaseQuery)query) != null) {
                        this.throwError("Employee should not have been found.");
                    }
                    if (counter.getSqlStatements().size() == 0) {
                        this.throwError("Query should have hit database.");
                    }
                    query = new ReadObjectQuery(Employee.class);
                    emp = new ExpressionBuilder();
                    query.setSelectionCriteria(emp.get("firstName").equal((Object)"cache").and(emp.get("lastName").equal((Object)"fail")));
                    counter.getSqlStatements().clear();
                    if (uow.executeQuery((DatabaseQuery)query) != employee) {
                        this.throwError("Employee should have been found.");
                    }
                    if (counter.getSqlStatements().size() > 0) {
                        this.throwError("Query should have hit cache.");
                    }
                }
                finally {
                    counter.remove();
                }
            }
        };
        test.setName("CacheIndexTest");
        test.setDescription("Tests cache indexes with new and changed objects.");
        return test;
    }
}

