/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.List;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.Address;

public class ReadAllvsReadAllFromResultSet
extends PerformanceComparisonTestCase {
    protected ReadAllQuery query;
    protected ReadAllQuery resultSetQuery;

    public ReadAllvsReadAllFromResultSet() {
        this.setDescription("This test compares the performance of read all vs reading directly from a result-set.");
        this.addTest((TestCase)this.readAllFromResultSet());
    }

    public void setup() {
        this.query = new ReadAllQuery(Address.class);
        this.resultSetQuery = new ReadAllQuery(Address.class);
        this.resultSetQuery.setIsResultSetOptimizedQuery(true);
    }

    public void reset() throws Exception {
    }

    public void test() throws Exception {
        UnitOfWork unitOfWork = this.getSession().acquireUnitOfWork();
        unitOfWork.beginEarlyTransaction();
        List results = (List)unitOfWork.executeQuery((DatabaseQuery)this.query);
        unitOfWork.release();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public PerformanceComparisonTestCase readAllFromResultSet() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                UnitOfWork unitOfWork = this.getSession().acquireUnitOfWork();
                unitOfWork.beginEarlyTransaction();
                List results = (List)unitOfWork.executeQuery((DatabaseQuery)ReadAllvsReadAllFromResultSet.this.resultSetQuery);
                unitOfWork.release();
                this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            }
        };
        test.setName("ReadAllFromResultSet");
        return test;
    }
}

