/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.aggregate.Computer;
import org.eclipse.persistence.testing.models.aggregate.Employee;
import org.eclipse.persistence.testing.models.aggregate.Language;
import org.eclipse.persistence.testing.models.aggregate.ProjectDescription;
import org.eclipse.persistence.testing.models.aggregate.Responsibility;

public class MergingUnitOfWorkTest
extends WriteObjectTest {
    public UnitOfWork unitOfWork1;
    public UnitOfWork unitOfWork2;
    public Employee workingCopy1;
    public Employee workingCopy2;
    public Employee mergedCopy;

    public MergingUnitOfWorkTest(Object originalObject) {
        super(originalObject);
        this.setDescription("This suite tests merging of objects from two UOWs in the aggregate model.");
    }

    protected void changeWorkingCopy1() {
        this.workingCopy1.setFirstName("Kevin");
        ProjectDescription projectDescription = this.workingCopy1.getProjectDescription();
        projectDescription.setDescription("Quality Assurance project");
        ((Vector)projectDescription.getResponsibilities().getValue()).removeElement(((Vector)projectDescription.getResponsibilities().getValue()).firstElement());
        ((Vector)projectDescription.getResponsibilities().getValue()).addElement(Responsibility.example1(this.workingCopy1));
        ((Vector)projectDescription.getResponsibilities().getValue()).addElement(Responsibility.example2(this.workingCopy1));
        ((Vector)projectDescription.getLanguages().getValue()).removeElement(((Vector)projectDescription.getLanguages().getValue()).firstElement());
        ((Vector)projectDescription.getLanguages().getValue()).addElement(Language.example1());
        ((Vector)projectDescription.getLanguages().getValue()).addElement(Language.example2());
        ((Computer)projectDescription.getComputer().getValue()).setDescription("Commodore 64");
    }

    protected void deepMergeWorkingCopies() {
        this.unitOfWork2 = this.getSession().acquireUnitOfWork();
        this.workingCopy2 = (Employee)this.unitOfWork2.registerObject(this.originalObject);
        this.mergedCopy = (Employee)this.unitOfWork2.deepMergeClone((Object)this.workingCopy1);
        ProjectDescription projectDescription = this.mergedCopy.getProjectDescription();
        Vector responsibilities = (Vector)projectDescription.getResponsibilities().getValue();
        Vector languages = (Vector)projectDescription.getLanguages().getValue();
        Computer computer = (Computer)projectDescription.getComputer().getValue();
        if (this.mergedCopy.getFirstName() != "Kevin") {
            throw new TestErrorException("Deep Merge did not merge changes in Employee.");
        }
        if (projectDescription.getDescription() != "Quality Assurance project") {
            throw new TestErrorException("Deep Merge did not merge changes in ProjectDescription (Aggregate mapping).");
        }
        if (responsibilities.size() != ((Vector)this.workingCopy1.getProjectDescription().getResponsibilities().getValue()).size()) {
            throw new TestErrorException("Deep Merge did not merge changes in Responsibility (private 1:M).");
        }
        if (languages.size() != ((Vector)this.workingCopy1.getProjectDescription().getLanguages().getValue()).size()) {
            throw new TestErrorException("Deep Merge did not merge changes in Language (public M:M).");
        }
        if (computer.getDescription() != "Commodore 64") {
            throw new TestErrorException("Deep Merge did not merge changes in Computer (private 1:1).");
        }
        this.mergedCopy = (Employee)this.unitOfWork2.deepRevertObject((Object)this.workingCopy2);
        projectDescription = this.mergedCopy.getProjectDescription();
        responsibilities = (Vector)projectDescription.getResponsibilities().getValue();
        languages = (Vector)projectDescription.getLanguages().getValue();
        computer = (Computer)projectDescription.getComputer().getValue();
        if (this.mergedCopy.getFirstName() == "Kevin") {
            throw new TestErrorException("Deep revert did not merge changes in Employee.");
        }
        if (projectDescription.getDescription() == "Quality Assurance project") {
            throw new TestErrorException("Deep revert did not merge changes in ProjectDescription (Aggregate mapping).");
        }
        if (responsibilities.size() == ((Vector)this.workingCopy1.getProjectDescription().getResponsibilities().getValue()).size()) {
            throw new TestErrorException("Deep revert did not merge changes in Responsibility (private 1:M).");
        }
        if (languages.size() == ((Vector)this.workingCopy1.getProjectDescription().getLanguages().getValue()).size()) {
            throw new TestErrorException("Deep revert did not merge changes in Language (public M:M).");
        }
        if (computer.getDescription() == "Commodore 64") {
            throw new TestErrorException("Deep revert did not merge changes in Computer (private 1:1).");
        }
        this.unitOfWork2.deepMergeClone((Object)this.workingCopy1);
        this.mergedCopy = (Employee)this.unitOfWork2.shallowRevertObject((Object)this.workingCopy2);
        projectDescription = this.mergedCopy.getProjectDescription();
        responsibilities = (Vector)projectDescription.getResponsibilities().getValue();
        languages = (Vector)projectDescription.getLanguages().getValue();
        computer = (Computer)projectDescription.getComputer().getValue();
        if (this.mergedCopy.getFirstName() == "Kevin") {
            throw new TestErrorException("Shallow revert did not merge changes in Employee.");
        }
        if (projectDescription.getDescription() == "Quality Assurance project") {
            throw new TestErrorException("Shallow revert did not merge changes in ProjectDescription (Aggregate mapping).");
        }
        if (responsibilities.size() == ((Vector)this.workingCopy1.getProjectDescription().getResponsibilities().getValue()).size()) {
            throw new TestErrorException("Shallow revert did not merge changes in Responsibility (private 1:M).");
        }
        if (languages.size() == ((Vector)this.workingCopy1.getProjectDescription().getLanguages().getValue()).size()) {
            throw new TestErrorException("Shallow revert did not merge changes in Language (public M:M).");
        }
        if (computer.getDescription() != "Commodore 64") {
            throw new TestErrorException("Shallow revert did not merge changes in Computer (private 1:1).");
        }
        this.unitOfWork2.deepMergeClone((Object)this.workingCopy1);
        this.mergedCopy = (Employee)this.unitOfWork2.revertObject((Object)this.workingCopy2);
        projectDescription = this.mergedCopy.getProjectDescription();
        responsibilities = (Vector)projectDescription.getResponsibilities().getValue();
        languages = (Vector)projectDescription.getLanguages().getValue();
        computer = (Computer)projectDescription.getComputer().getValue();
        if (this.mergedCopy.getFirstName() == "Kevin") {
            throw new TestErrorException("Revert did not merge changes in Employee.");
        }
        if (projectDescription.getDescription() == "Quality Assurance project") {
            throw new TestErrorException("Revert did not merge changes in ProjectDescription (Aggregate mapping).");
        }
        if (responsibilities.size() == ((Vector)this.workingCopy1.getProjectDescription().getResponsibilities().getValue()).size()) {
            throw new TestErrorException("Revert did not merge changes in Responsibility (private 1:M).");
        }
        if (languages.size() == ((Vector)this.workingCopy1.getProjectDescription().getLanguages().getValue()).size()) {
            throw new TestErrorException("Revert did not merge changes in Language (public M:M).");
        }
        if (computer.getDescription() == "Commodore 64") {
            throw new TestErrorException("Revert did not merge changes in Computer (private 1:1).");
        }
    }

    protected void setup() {
        super.setup();
        this.unitOfWork1 = this.getSession().acquireUnitOfWork();
        this.workingCopy1 = (Employee)this.unitOfWork1.registerObject(this.originalObject);
        this.changeWorkingCopy1();
        this.standardMergeWorkingCopies();
        this.shallowMergeWorkingCopies();
        this.deepMergeWorkingCopies();
    }

    protected void shallowMergeWorkingCopies() {
        this.unitOfWork2 = this.getSession().acquireUnitOfWork();
        this.workingCopy2 = (Employee)this.unitOfWork2.registerObject(this.originalObject);
        this.mergedCopy = (Employee)this.unitOfWork2.shallowMergeClone((Object)this.workingCopy1);
        ProjectDescription projectDescription = this.mergedCopy.getProjectDescription();
        Vector responsibilities = (Vector)projectDescription.getResponsibilities().getValue();
        Vector languages = (Vector)projectDescription.getLanguages().getValue();
        Computer computer = (Computer)projectDescription.getComputer().getValue();
        if (this.mergedCopy.getFirstName() != "Kevin") {
            throw new TestErrorException("Shallow Merge did not merge changes in Employee.");
        }
        if (projectDescription.getDescription() != "Quality Assurance project") {
            throw new TestErrorException("Shallow Merge merged changes in ProjectDescription (Aggregate mapping) but shouldn't have.");
        }
        if (responsibilities.size() == ((Vector)this.workingCopy1.getProjectDescription().getResponsibilities().getValue()).size()) {
            throw new TestErrorException("Shallow Merge merged changes in Responsibility (private 1:M) but shouldn't have.");
        }
        if (languages.size() == ((Vector)this.workingCopy1.getProjectDescription().getLanguages().getValue()).size()) {
            throw new TestErrorException("Shallow Merge merged changes in Language (public M:M) but shouldn't have.");
        }
        if (computer.getDescription() == "Commodore 64") {
            throw new TestErrorException("Shallow Merge merged changes in Computer (private 1:1) but shouldn't have.");
        }
    }

    protected void standardMergeWorkingCopies() {
        this.unitOfWork2 = this.getSession().acquireUnitOfWork();
        this.workingCopy2 = (Employee)this.unitOfWork2.registerObject(this.originalObject);
        this.mergedCopy = (Employee)this.unitOfWork2.mergeClone((Object)this.workingCopy1);
        ProjectDescription projectDescription = this.mergedCopy.getProjectDescription();
        Vector responsibilities = (Vector)projectDescription.getResponsibilities().getValue();
        Vector languages = (Vector)projectDescription.getLanguages().getValue();
        Computer computer = (Computer)projectDescription.getComputer().getValue();
        if (this.mergedCopy.getFirstName() != "Kevin") {
            throw new TestErrorException("Standard Merge did not merge changes in Employee.");
        }
        if (projectDescription.getDescription() != "Quality Assurance project") {
            throw new TestErrorException("Standard Merge did not merge changes in ProjectDescription (Aggregate mapping).");
        }
        if (responsibilities.size() != ((Vector)this.workingCopy1.getProjectDescription().getResponsibilities().getValue()).size()) {
            throw new TestErrorException("Standard Merge did not merge changes in Responsibility (private 1:M).");
        }
        if (languages.size() == ((Vector)this.workingCopy1.getProjectDescription().getLanguages().getValue()).size()) {
            throw new TestErrorException("Standard Merge merged changes in Language (public M:M) but shouldn't have.");
        }
        if (computer.getDescription() != "Commodore 64") {
            throw new TestErrorException("Standard Merge did not merge changes in Computer (private 1:1).");
        }
    }

    protected void test() {
    }

    protected void verify() {
    }
}

