/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.types;

import java.util.Random;
import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.types.TypeTester;
import org.eclipse.persistence.testing.tests.types.WriteTypeObjectTest;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class BLOBTester
extends TypeTester {
    public byte[] bytes;
    protected int length;

    public BLOBTester() {
        this(0);
    }

    public BLOBTester(int numBytes) {
        super("BLOB(" + numBytes + ")");
        this.length = numBytes;
        this.bytes = null;
    }

    private String buildName() {
        return "BLOB(" + this.length + ")";
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(BLOBTester.class);
        descriptor.setTableName("BLOBS");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
        descriptor.addDirectMapping("bytes", "BLOB_");
        return descriptor;
    }

    public static RelationalDescriptor descriptorWithAccessors() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(BLOBTester.class);
        descriptor.setTableName("BLOBS");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
        descriptor.addDirectMapping("bytes", "getBytes", "setBytes", "BLOB_");
        return descriptor;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] newBytes) {
        this.length = newBytes.length;
        this.bytes = newBytes;
    }

    @Override
    public void setup(Session session) {
        if (session.getPlatform().isAccess()) {
            throw new TestWarningException("Access and DB2 do not support BLOBS or CLOBS.");
        }
        if (this.bytes == null) {
            this.bytes = new byte[this.length];
            new Random().nextBytes(this.bytes);
        }
    }

    public static TableDefinition tableDefinition(Session session) {
        TableDefinition definition = TypeTester.tableDefinition();
        definition.setName("BLOBS");
        definition.addField("BLOB_", Byte[].class, 33000);
        return definition;
    }

    @Override
    protected void test(WriteTypeObjectTest testCase) throws TestWarningException {
        try {
            super.test(testCase);
        }
        catch (NullPointerException e) {
            throw new TestWarningException("Blob value was returned as null, this means the drivers max size was exceeded." + Helper.cr() + (Object)((Object)this.caughtException));
        }
    }

    public static Vector testInstances() {
        Vector<BLOBTester> tests = new Vector<BLOBTester>();
        tests.addElement(new BLOBTester(1000));
        tests.addElement(new BLOBTester(5000));
        tests.addElement(new BLOBTester(10000));
        tests.addElement(new BLOBTester(25000));
        tests.addElement(new BLOBTester(32768));
        tests.addElement(new BLOBTester(33000));
        return tests;
    }

    public String toString() {
        if (this.getTestName().equals(this.buildName())) {
            return this.getTestName();
        }
        return this.getTestName() + " {" + this.length + "}";
    }

    @Override
    protected void verify(WriteTypeObjectTest testCase) throws TestException {
        try {
            super.verify(testCase);
        }
        catch (TestException e) {
            if (this.caughtException != null && this.caughtException.toString().indexOf("JZ0S8: An escape sequence") != -1) {
                throw new TestProblemException("JConnect does not do BLOBs in non-native SQL:\n" + this.caughtException.getInternalException());
            }
            if (e.getInternalException() != null && e.getInternalException().getClass() == IllegalAccessException.class) {
                try {
                    Class.forName("com.ibm.uvm.tools.DebugSupport");
                    throw new TestWarningException("IllegalAccessException attempting to reflectively set byte[]");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            BLOBTester original = (BLOBTester)testCase.getOriginalObject();
            BLOBTester database = (BLOBTester)testCase.getObjectFromDatabase();
            if (database == null) {
                throw new TestWarningException("Write of BLOB failed, nothing was written or read.\n" + (Object)((Object)this.caughtException));
            }
            if (database.getBytes() != null && original.getBytes().length == database.getBytes().length) {
                int numGood = 0;
                for (int index = 0; index < original.getBytes().length; ++index) {
                    if (original.getBytes()[index] != database.getBytes()[index]) continue;
                    ++numGood;
                }
                throw new TestWarningException("Two BLOBs did not match, " + numGood + " bytes matched");
            }
            throw new TestWarningException("Blobs just suck with this driver or max size exceeded, \n" + (Object)((Object)e));
        }
    }
}

