/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection.jdk8;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectMapTestAPI;

public class IndirectMapTestAPI8
extends IndirectMapTestAPI {
    public IndirectMapTestAPI8(String name, Class<? extends IndirectMap> cls, boolean useListener) {
        super(name, cls, useListener);
    }

    public void testCompute() {
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        String s1 = this.map.compute("one", new BF_S());
        String s2 = (String)this.testMap.compute((Object)"one", (BiFunction)new BF_S());
        IndirectMapTestAPI8.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI8.assertEquals((String)"111suffix", (String)((String)this.testMap.get((Object)"one")));
        this.assertRemoveAddEvents(1);
    }

    public void testCompute2() {
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        String s1 = this.map.compute("notExist", new BF_S());
        String s2 = (String)this.testMap.compute((Object)"notExist", (BiFunction)new BF_S());
        IndirectMapTestAPI8.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI8.assertEquals((String)"nullsuffix", (String)((String)this.testMap.get((Object)"notExist")));
        this.assertAddEvents(1);
    }

    public void testComputeIfAbsent() {
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        String s1 = this.map.computeIfAbsent("one", new F());
        String s2 = (String)this.testMap.computeIfAbsent((Object)"one", (Function)new F());
        IndirectMapTestAPI8.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI8.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        this.assertNoEvents();
    }

    public void testComputeIfAbsent2() {
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        String s1 = this.map.computeIfAbsent("notExist", new F());
        String s2 = (String)this.testMap.computeIfAbsent((Object)"notExist", (Function)new F());
        IndirectMapTestAPI8.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        this.assertAddEvents(1);
    }

    public void testComputeIfPresent() {
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        String s1 = this.map.computeIfPresent("one", new BF_S());
        String s2 = (String)this.testMap.computeIfPresent((Object)"one", (BiFunction)new BF_S());
        IndirectMapTestAPI8.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI8.assertEquals((String)"111suffix", (String)((String)this.testMap.get((Object)"one")));
        this.assertRemoveAddEvents(1);
    }

    public void testComputeIfPresent2() {
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        String s1 = this.map.computeIfPresent("notExist", new BF_S());
        String s2 = (String)this.testMap.computeIfPresent((Object)"notExist", (BiFunction)new BF_S());
        IndirectMapTestAPI8.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI8.assertNull((Object)this.testMap.get((Object)"notExist"));
        this.assertNoEvents();
    }

    public void testEntrySetRemoveIf() {
        Predicate<Map.Entry<String, String>> p = new Predicate<Map.Entry<String, String>>(){

            @Override
            public boolean test(Map.Entry<String, String> item) {
                return "one".equals(item.getKey());
            }
        };
        Set entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        boolean result1 = entrySet.removeIf(p);
        boolean result2 = testEntrySet.removeIf(p);
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI8.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI8.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    public void testForEach() {
        C c1 = new C();
        C c2 = new C();
        this.map.forEach(c1);
        this.testMap.forEach((BiConsumer)c2);
        this.assertUnorderedElementsEqual(c1.v, c2.v);
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        this.assertNoEvents();
    }

    public void testGetOrDefault() {
        IndirectMapTestAPI8.assertFalse((boolean)this.testMap.containsKey((Object)"temp"));
        Object o = this.testMap.getOrDefault((Object)"temp", (Object)"1234");
        IndirectMapTestAPI8.assertNotNull((String)"Should return value", (Object)o);
        IndirectMapTestAPI8.assertEquals((Object)"1234", (Object)o);
        IndirectMapTestAPI8.assertTrue((boolean)this.testMap.containsKey((Object)"one"));
        o = this.testMap.getOrDefault((Object)"one", (Object)"5678");
        IndirectMapTestAPI8.assertNotNull((String)"Should return value", (Object)o);
        IndirectMapTestAPI8.assertEquals((Object)"111", (Object)o);
        this.assertNoEvents();
    }

    public void testKeySetRemoveIf() {
        Predicate<String> p = new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return s.startsWith("s");
            }
        };
        Set keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        boolean result1 = keySet.removeIf(p);
        boolean result2 = testKeySet.removeIf(p);
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI8.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI8.assertNull((Object)this.testMap.get((Object)"six"));
        this.assertRemoveEvents(2);
    }

    public void testMerge() {
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        String s1 = this.map.merge("one", "custom", new BF());
        String s2 = (String)this.testMap.merge((Object)"one", (Object)"custom", (BiFunction)new BF());
        IndirectMapTestAPI8.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI8.assertEquals((String)"111custom", (String)((String)this.testMap.get((Object)"one")));
        this.assertRemoveAddEvents(1);
    }

    public void testMerge2() {
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        String s1 = this.map.merge("notExist", "custom", new BF());
        String s2 = (String)this.testMap.merge((Object)"notExist", (Object)"custom", (BiFunction)new BF());
        IndirectMapTestAPI8.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI8.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        this.assertAddEvents(1);
    }

    public void testPutIfAbsent() {
        IndirectMapTestAPI8.assertFalse((boolean)this.testMap.containsKey((Object)"temp"));
        Object o = this.testMap.putIfAbsent((Object)"temp", (Object)"1234");
        IndirectMapTestAPI8.assertNull((String)"Should return null", (Object)o);
        this.assertAddEvents(1);
        IndirectMapTestAPI8.assertTrue((boolean)this.testMap.containsKey((Object)"temp"));
        o = this.testMap.putIfAbsent((Object)"temp", (Object)"5678");
        IndirectMapTestAPI8.assertNotNull((String)"Should return value", (Object)o);
        IndirectMapTestAPI8.assertEquals((Object)"1234", (Object)o);
        this.assertAddEvents(1);
    }

    public void testRemoveTwoArgs() {
        IndirectMapTestAPI8.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        Boolean o = this.testMap.remove((Object)"one", (Object)"1234");
        IndirectMapTestAPI8.assertFalse((String)"Should return false", (boolean)o);
        this.assertNoEvents();
        IndirectMapTestAPI8.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        o = this.testMap.remove((Object)"one", (Object)"111");
        IndirectMapTestAPI8.assertTrue((String)"Should return true", (boolean)o);
        IndirectMapTestAPI8.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    public void testReplace() {
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        Object o = this.testMap.replace((Object)"one", (Object)"1");
        IndirectMapTestAPI8.assertEquals((Object)this.map.replace("one", "1"), (Object)o);
        IndirectMapTestAPI8.assertNotNull((String)"Should return value", (Object)o);
        IndirectMapTestAPI8.assertEquals((Object)"111", (Object)o);
        IndirectMapTestAPI8.assertEquals((String)"1", (String)((String)this.testMap.get((Object)"one")));
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        this.assertRemoveAddEvents(1);
        IndirectMapTestAPI8.assertNull((Object)this.map.replace("blablablabla", "whatever"));
        IndirectMapTestAPI8.assertNull((Object)this.testMap.replace((Object)"blablablabla", (Object)"whatever"));
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        this.assertRemoveAddEvents(1);
    }

    public void testReplaceAll() {
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        this.map.replaceAll(new BF_S());
        this.testMap.replaceAll((BiFunction)new BF_S());
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        this.assertRemoveAddEvents(this.testMap.size());
    }

    public void testReplaceWithDefault() {
        IndirectMapTestAPI8.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        Boolean o = this.testMap.replace((Object)"one", (Object)"1", (Object)"1234");
        IndirectMapTestAPI8.assertEquals((Object)this.map.replace("one", "1", "1234"), (Object)o);
        IndirectMapTestAPI8.assertFalse((String)"Should return false", (boolean)o);
        IndirectMapTestAPI8.assertFalse((String)"Should not have '1234'", (boolean)this.testMap.containsValue((Object)"1234"));
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        this.assertNoEvents();
        IndirectMapTestAPI8.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        o = this.testMap.replace((Object)"one", (Object)"111", (Object)"1234");
        IndirectMapTestAPI8.assertEquals((Object)this.map.replace("one", "111", "1234"), (Object)o);
        IndirectMapTestAPI8.assertTrue((String)"Should return true", (boolean)o);
        IndirectMapTestAPI8.assertEquals((String)"1234", (String)((String)this.testMap.get((Object)"one")));
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        this.assertRemoveAddEvents(1);
    }

    public void testValuesRemoveIf() {
        Predicate<String> p = new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return s.startsWith("2");
            }
        };
        Collection keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        boolean result1 = keySet.removeIf(p);
        boolean result2 = testKeySet.removeIf(p);
        IndirectMapTestAPI8.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI8.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI8.assertNull((Object)this.testMap.get((Object)"two"));
        this.assertRemoveEvents(1);
    }

    private static final class P
    implements Predicate<String> {
        private final List list;

        P(List l) {
            this.list = l;
        }

        @Override
        public boolean test(String s) {
            return this.list.contains(s);
        }
    }

    private static final class F
    implements Function<String, String> {
        private F() {
        }

        @Override
        public String apply(String a) {
            return "newitem";
        }
    }

    private static final class C
    implements BiConsumer<String, String> {
        private final Vector<String> v = new Vector();

        C() {
        }

        @Override
        public void accept(String a, String b) {
            this.v.add(a);
            this.v.add(b);
        }
    }

    private static final class BF_S
    implements BiFunction<String, String, String> {
        private BF_S() {
        }

        @Override
        public String apply(String a, String b) {
            return b != null ? b + "suffix" : "nullsuffix";
        }
    }

    private static final class BF
    implements BiFunction<String, String, String> {
        private BF() {
        }

        @Override
        public String apply(String a, String b) {
            return a != null ? a.concat(b) : b;
        }
    }
}

