/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollectionsFactory;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.JavaSEPlatform;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.transparentindirection.TestSession;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestSuite;

public class IndirectSetTestAPI
extends ZTestCase {
    protected Vector<String> list;
    protected IndirectSet<String> testList;
    private Listener testListLsn;
    private Class<? extends IndirectSet> cls;
    private boolean useListener;

    public IndirectSetTestAPI(String name) {
        this(name, null, true);
    }

    public IndirectSetTestAPI(String name, Class<? extends IndirectSet> cls, boolean useListener) {
        super(name);
        this.cls = cls;
        this.useListener = useListener;
    }

    public static TestSuite getTestSuiteFor(Class<? extends IndirectSet> cls, boolean useListener) {
        ZTestSuite ts = new ZTestSuite("Suite for " + cls.getName() + "(useListener: " + useListener + ")");
        ts.addTest((Test)new IndirectSetTestAPI("testAdd", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testAddAll", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testClear", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testContains", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testContainsAll", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testEquals", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testIsEmpty", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testIterator", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testRemove", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testRemoveAll", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testRetainAll", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testSize", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testToArray1", cls, useListener));
        ts.addTest((Test)new IndirectSetTestAPI("testToArray2", cls, useListener));
        if (JavaSEPlatform.atLeast((JavaSEPlatform)JavaSEPlatform.v1_8) && cls.getName().contains(".jdk8.")) {
            try {
                Constructor<?> c = Class.forName("org.eclipse.persistence.testing.tests.transparentindirection.jdk8.IndirectSetTestAPI8").getConstructor(String.class, Class.class, Boolean.TYPE);
                ts.addTest((Test)((TestCase)c.newInstance("testForEach", cls, useListener)));
                ts.addTest((Test)((TestCase)c.newInstance("testParallelStream", cls, useListener)));
                ts.addTest((Test)((TestCase)c.newInstance("testRemoveIf", cls, useListener)));
                ts.addTest((Test)((TestCase)c.newInstance("testSpliterator", cls, useListener)));
                ts.addTest((Test)((TestCase)c.newInstance("testStream", cls, useListener)));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return ts;
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.list = this.setUpList();
        HashSet<String> temp = new HashSet<String>(this.list);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        if (this.cls == null) {
            this.testList = IndirectCollectionsFactory.createIndirectSet();
        } else {
            try {
                this.testList = this.cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        this.testList.setValueHolder((ValueHolderInterface)vh);
        if (this.useListener) {
            this.testListLsn = new Listener();
            this.testList._persistence_setPropertyChangeListener((PropertyChangeListener)this.testListLsn);
        }
    }

    protected Vector setUpList() {
        Vector<String> result = new Vector<String>();
        result.addElement("zero");
        result.addElement("one");
        result.addElement("two");
        result.addElement("three");
        result.addElement("four");
        result.addElement("five");
        result.addElement("six");
        result.addElement("seven");
        result.addElement("eight");
        result.addElement("nine");
        return result;
    }

    @Override
    protected void tearDown() {
        super.tearDown();
        if (this.useListener) {
            this.testListLsn.events.clear();
        }
    }

    public void testAdd() {
        String temp = "foo";
        this.list.add(temp);
        this.testList.add((Object)temp);
        this.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
        this.assertAddEvents(1);
    }

    public void testAddAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("foo");
        temp.addElement("bar");
        this.list.addAll(temp);
        this.testList.addAll(temp);
        this.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
        this.assertAddEvents(2);
    }

    public void testClear() {
        int originalSize = this.testList.size();
        this.list.clear();
        this.testList.clear();
        IndirectSetTestAPI.assertEquals(this.list, new Vector<String>((Collection<String>)this.testList));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.isEmpty());
        this.assertRemoveEvents(originalSize);
    }

    public void testContains() {
        IndirectSetTestAPI.assertTrue((boolean)this.testList.contains((Object)this.list.elementAt(1)));
        this.assertNoEvents();
    }

    public void testContainsAll() {
        IndirectSetTestAPI.assertTrue((boolean)this.testList.containsAll(this.list.subList(1, 5)));
        this.assertNoEvents();
    }

    public void testEquals() {
        IndirectSetTestAPI.assertTrue((boolean)this.testList.equals(new HashSet<String>(this.list)));
        this.assertNoEvents();
    }

    public void testIsEmpty() {
        IndirectSetTestAPI.assertTrue((!this.testList.isEmpty() ? 1 : 0) != 0);
        this.assertNoEvents();
    }

    public void testIterator() {
        int i = 0;
        Iterator stream = this.testList.iterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        IndirectSetTestAPI.assertEquals((int)this.list.size(), (int)i);
        this.assertNoEvents();
    }

    public void testRemove() {
        String temp = "one";
        IndirectSetTestAPI.assertTrue((boolean)this.list.remove(temp));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.remove((Object)temp));
        this.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        IndirectSetTestAPI.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(1);
    }

    public void testRemoveAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        IndirectSetTestAPI.assertTrue((boolean)this.list.removeAll(temp));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.removeAll(temp));
        this.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        IndirectSetTestAPI.assertTrue((!this.testList.containsAll(temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(2);
    }

    public void testRetainAll() {
        int originalSize = this.testList.size();
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        IndirectSetTestAPI.assertTrue((boolean)this.list.retainAll(temp));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.retainAll(temp));
        this.assertUnorderedElementsEqual(this.list, new Vector<String>((Collection<String>)this.testList));
        IndirectSetTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
        IndirectSetTestAPI.assertEquals((int)temp.size(), (int)this.testList.size());
        this.assertRemoveEvents(originalSize - temp.size());
    }

    public void testSize() {
        IndirectSetTestAPI.assertEquals((int)this.list.size(), (int)this.testList.size());
        this.assertNoEvents();
    }

    public void testToArray1() {
        Object[] temp = this.list.toArray();
        Vector<Object> v1 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = this.testList.toArray();
        Vector<Object> v2 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        this.assertUnorderedElementsEqual(v1, v2);
        this.assertNoEvents();
    }

    public void testToArray2() {
        String[] temp = this.list.toArray(new String[0]);
        Vector<String> v1 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = (String[])this.testList.toArray((Object[])new String[0]);
        Vector<String> v2 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        this.assertUnorderedElementsEqual(v1, v2);
        this.assertNoEvents();
    }

    protected void assertNoEvents() {
        if (this.useListener) {
            IndirectSetTestAPI.assertTrue((boolean)this.testListLsn.events.isEmpty());
        }
    }

    protected void assertAddEvents(int count) {
        if (this.useListener) {
            IndirectSetTestAPI.assertEquals((String)"events do not match", (int)count, (int)this.testListLsn.events.size());
            for (CollectionChangeEvent cce : this.testListLsn.events) {
                IndirectSetTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.ADD, (int)cce.getChangeType());
            }
        }
    }

    protected void assertRemoveEvents(int count) {
        if (this.useListener) {
            IndirectSetTestAPI.assertEquals((String)"events do not match", (int)count, (int)this.testListLsn.events.size());
            for (CollectionChangeEvent cce : this.testListLsn.events) {
                IndirectSetTestAPI.assertEquals((String)"expected add event", (int)CollectionChangeEvent.REMOVE, (int)cce.getChangeType());
            }
        }
    }

    private static final class Listener
    implements PropertyChangeListener {
        private List<CollectionChangeEvent> events = new ArrayList<CollectionChangeEvent>();

        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.events.add((CollectionChangeEvent)evt);
        }
    }
}

