/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.io.Writer;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.LoadBuildProject;
import org.eclipse.persistence.testing.framework.LoadBuildSummary;
import org.eclipse.persistence.testing.framework.TestResult;
import org.eclipse.persistence.testing.framework.TestResultsSummary;

public class LoadBuildSystem {
    public static LoadBuildSummary loadBuild = new LoadBuildSummary();
    public static LoadBuildSystem system;
    private DatabaseSession session = new LoadBuildProject().createDatabaseSession();

    public static LoadBuildSummary getSummary() {
        return loadBuild;
    }

    public static LoadBuildSystem getSystem() {
        if (system == null) {
            system = new LoadBuildSystem();
            system.login();
        }
        return system;
    }

    public static void main(String[] args) {
        LoadBuildSystem system = new LoadBuildSystem();
        system.login();
        system.logout();
    }

    public DatabaseSession getSession() {
        return this.session;
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public void login() {
        this.session.getLogin().useNativeSQL();
        this.session.getLogin().useBatchWriting();
        this.session.getLogin().bindAllParameters();
        this.session.getLogin().cacheAllStatements();
        this.session.getLogin().setMaxBatchWritingSize(50);
        this.session.dontLogMessages();
        this.session.login();
    }

    public void dropTables() {
        try {
            this.session.executeNonSelectingCall((Call)new SQLCall("drop table RESULT"));
            this.session.executeNonSelectingCall((Call)new SQLCall("drop table SUMMARY"));
            this.session.executeNonSelectingCall((Call)new SQLCall("drop table LOADBUILD"));
            this.session.executeNonSelectingCall((Call)new SQLCall("drop sequence result_seq"));
            this.session.executeNonSelectingCall((Call)new SQLCall("drop sequence RESULTSUM_SEQ"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createTables() {
        this.session.executeNonSelectingCall((Call)new SQLCall("Create table LOADBUILD (id number(10), lbtimestamp date, lberrors number(10), fatalErrors number(10), loginChoice varchar2(100), os varchar2(100), toplink_version varchar(100), jvm varchar2(100), machine varchar2(100), numberOfTests number(10), lbuserName varchar2(50), primary key (id))"));
        this.session.executeNonSelectingCall((Call)new SQLCall("Create table RESULT (id number(10), description varchar2(2000), exception varchar2(2000), name varchar2(1000), outcome varchar2(100), test_time number(10), total_time number(10), summaryId number(10), lbuildId number(10), primary key (id))"));
        this.session.executeNonSelectingCall((Call)new SQLCall("Create table SUMMARY (id number(10), description varchar2(2000), setup_failures number(10), errors number(10), fatalErrors number(10), name varchar2(1000), passed number(10), problems number(10), setupException varchar2(2000), total_time number(10), totalTests number(10), warnings number(10), lbuildId number(10), parentId number(10), primary key (id))"));
        if (this.session.getPlatform().supportsUniqueKeyConstraints() && !this.session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
            this.session.executeNonSelectingCall((Call)new SQLCall("ALTER TABLE RESULT ADD CONSTRAINT FK_RESULT_summaryId FOREIGN KEY (summaryId) REFERENCES SUMMARY (id)"));
            this.session.executeNonSelectingCall((Call)new SQLCall("ALTER TABLE RESULT ADD CONSTRAINT FK_RESULT_lbuildId FOREIGN KEY (lbuildId) REFERENCES LOADBUILD (id)"));
            this.session.executeNonSelectingCall((Call)new SQLCall("ALTER TABLE SUMMARY ADD CONSTRAINT FK_LOADBUILD_lbuildId FOREIGN KEY (lbuildId) REFERENCES LOADBUILD (id)"));
            this.session.executeNonSelectingCall((Call)new SQLCall("ALTER TABLE SUMMARY ADD CONSTRAINT FK_LOADBUILD_parentId FOREIGN KEY (parentId) REFERENCES SUMMARY (id)"));
        }
        this.session.executeNonSelectingCall((Call)new SQLCall(this.session.getPlatform().buildCreateIndex("LOADBUILD", "IX_LOADBUILD_lbtimestamp", "", false, new String[]{"lbtimestamp"})));
        this.session.executeNonSelectingCall((Call)new SQLCall(this.session.getPlatform().buildCreateIndex("LOADBUILD", "IX_LOADBUILD_loginChoice", "", false, new String[]{"loginChoice"})));
        this.session.executeNonSelectingCall((Call)new SQLCall(this.session.getPlatform().buildCreateIndex("LOADBUILD", "IX_LOADBUILD_toplink_version", "", false, new String[]{"toplink_version"})));
        this.session.executeNonSelectingCall((Call)new SQLCall(this.session.getPlatform().buildCreateIndex("LOADBUILD", "IX_LOADBUILD_machine", "", false, new String[]{"machine"})));
        this.session.executeNonSelectingCall((Call)new SQLCall(this.session.getPlatform().buildCreateIndex("LOADBUILD", "IX_LOADBUILD_lbuserName", "", false, new String[]{"lbuserName"})));
        this.session.executeNonSelectingCall((Call)new SQLCall(this.session.getPlatform().buildCreateIndex("RESULT", "IX_RESULT_name", "", false, new String[]{"name"})));
        this.session.executeNonSelectingCall((Call)new SQLCall(this.session.getPlatform().buildCreateIndex("RESULT", "IX_RESULT_summaryId", "", false, new String[]{"summaryId"})));
        this.session.executeNonSelectingCall((Call)new SQLCall(this.session.getPlatform().buildCreateIndex("RESULT", "IX_RESULT_lbuildId", "", false, new String[]{"lbuildId"})));
        this.session.executeNonSelectingCall((Call)new SQLCall(this.session.getPlatform().buildCreateIndex("SUMMARY", "IX_SUMMARY_lbuildId", "", false, new String[]{"lbuildId"})));
        this.session.executeNonSelectingCall((Call)new SQLCall(this.session.getPlatform().buildCreateIndex("SUMMARY", "IX_SUMMARY_name", "", false, new String[]{"name"})));
        this.session.executeNonSelectingCall((Call)new SQLCall(this.session.getPlatform().buildCreateIndex("SUMMARY", "IX_SUMMARY_parentId", "", false, new String[]{"parentId"})));
        this.session.executeNonSelectingCall((Call)new SQLCall("create sequence result_seq increment by 500 start with 1000"));
        this.session.executeNonSelectingCall((Call)new SQLCall("create sequence RESULTSUM_SEQ increment by 500 start with 1000"));
    }

    public void logout() {
        this.session.logout();
    }

    public void populateSampleData() {
        ReadAllQuery query = new ReadAllQuery(LoadBuildSummary.class);
        query.addBatchReadAttribute("results");
        query.addBatchReadAttribute("summaries");
        query.addBatchReadAttribute(query.getExpressionBuilder().get("summaries").get("results"));
        List list = (List)this.session.executeQuery((DatabaseQuery)query);
        Iterator summaries = list.iterator();
        System.out.println("Size: " + list.size());
        UnitOfWork uow = this.session.acquireUnitOfWork();
        while (summaries.hasNext()) {
            LoadBuildSummary summary = (LoadBuildSummary)summaries.next();
            Iterator iterator = summary.getSummaries().iterator();
            while (iterator.hasNext()) {
                ((TestResultsSummary)iterator.next()).getResults();
            }
            CopyGroup group = new CopyGroup();
            group.setShouldResetPrimaryKey(true);
            LoadBuildSummary summaryCopy = (LoadBuildSummary)this.session.copy((Object)summary, (AttributeGroup)group);
            summaryCopy.id = 0L;
            uow.registerObject((Object)summaryCopy);
        }
        uow.commit();
        list = this.session.readAllObjects(LoadBuildSummary.class);
        System.out.println("Size: " + list.size());
    }

    public void populate() {
        if (loadBuild == null) {
            return;
        }
        UnitOfWork uow = this.session.acquireUnitOfWork();
        LoadBuildSystem.loadBuild.timestamp = new Timestamp(System.currentTimeMillis());
        loadBuild.initializeLoadBuild();
        loadBuild.computeNumberOfTestsAndErrors();
        uow.registerObject((Object)loadBuild);
        uow.commit();
    }

    public Vector readAllTestModelSummaries(Expression expression) {
        ReadAllQuery query = new ReadAllQuery(TestResultsSummary.class, expression);
        query.addAscendingOrdering("name");
        query.addOrdering(query.getExpressionBuilder().get("loadBuildSummary").get("timestamp").ascending());
        query.addJoinedAttribute("loadBuildSummary");
        return (Vector)this.session.executeQuery((DatabaseQuery)query);
    }

    public Vector readAllTests(Expression expression) {
        ReadAllQuery query = new ReadAllQuery(TestResult.class, expression);
        query.addAscendingOrdering("name");
        query.addOrdering(query.getExpressionBuilder().get("loadBuildSummary").get("timestamp").ascending());
        query.addJoinedAttribute("loadBuildSummary");
        return (Vector)this.session.executeQuery((DatabaseQuery)query);
    }

    public void saveLoadBuild() {
        boolean success = true;
        try {
            this.login();
            this.populate();
        }
        catch (Exception e) {
            System.out.println("Error occurred during saving of test results to database.");
            e.printStackTrace();
            System.out.println("Saving of test results failed.");
            success = false;
        }
        if (success) {
            System.out.println("Saving of test results successful.");
        }
        loadBuild = new LoadBuildSummary();
        this.logout();
    }

    public void saveLoadBuild(Writer log) {
        try {
            this.session.setLogLevel(3);
            this.session.setLog(log);
            this.login();
            this.populate();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        loadBuild = new LoadBuildSummary();
        this.logout();
    }
}

