/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;

public class CascadeWithoutIMOnRemote
extends TestCase {
    protected Employee emp1;
    protected Employee emp2;
    protected PolicyHolder holder1;
    protected PolicyHolder holder2;

    public CascadeWithoutIMOnRemote() {
        this.setDescription("Tests if remote refresh cascades parts without maintain cache (on query) correctly.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() throws Exception {
        this.emp1 = (Employee)this.getSession().readObject(Employee.class);
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject((Object)this.emp1);
        query.dontMaintainCache();
        query.dontCascadeParts();
        this.emp2 = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        this.holder1 = (PolicyHolder)this.getSession().readObject(PolicyHolder.class);
        ReadObjectQuery query2 = new ReadObjectQuery();
        query2.setSelectionObject((Object)this.holder1);
        query2.dontMaintainCache();
        query2.dontCascadeParts();
        this.holder2 = (PolicyHolder)this.getSession().executeQuery((DatabaseQuery)query2);
    }

    public void verify() throws Exception {
        if (this.emp1 == this.emp2 || this.emp1.getAddress() != this.emp2.getAddress() || this.emp1.getPhoneNumbers() != this.emp2.getPhoneNumbers()) {
            throw new TestWarningException("Cascade part with no IM on remote with indirection fails on remote.");
        }
        if (this.holder1 == this.holder2 || this.holder1.getAddress() != this.holder2.getAddress() || this.holder1.getPolicies() != this.holder2.getPolicies()) {
            throw new TestWarningException("Cascade part with no IM on remote without indirection fails on remote.");
        }
    }
}

