/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import java.sql.Timestamp;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class TimestampFromStringTest
extends AutoVerifyTestCase {
    String currentTime;
    Timestamp optimizedTime;
    boolean optimizedDatesState;

    public static void main(String[] args) {
        TimestampFromStringTest test = new TimestampFromStringTest();
        test.setup();
        test.test();
        test.verify();
        test.reset();
    }

    public TimestampFromStringTest() {
        this.setDescription("Test of Helper.timestampFromString(String stringObject)");
    }

    public void setup() {
        this.currentTime = new Timestamp(System.currentTimeMillis()).toString();
        this.optimizedDatesState = Helper.shouldOptimizeDates();
    }

    public void test() {
        Helper.setShouldOptimizeDates((boolean)true);
        this.optimizedTime = Helper.timestampFromString((String)this.currentTime);
    }

    public void verify() {
        if (!this.currentTime.equals(this.optimizedTime.toString())) {
            throw new TestErrorException("Failed to convert String to java.sql.Timestamp when shouldOptimizedDates is on");
        }
    }

    public void reset() {
        Helper.setShouldOptimizeDates((boolean)this.optimizedDatesState);
    }
}

