/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.mapping;

import java.math.BigDecimal;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.mapping.Address;
import org.eclipse.persistence.testing.models.mapping.BiDirectionInserOrderTestProject;
import org.eclipse.persistence.testing.models.mapping.BiDirectionInsertOrderTableMaker;
import org.eclipse.persistence.testing.models.mapping.CompanyCard;
import org.eclipse.persistence.testing.models.mapping.Computer;
import org.eclipse.persistence.testing.models.mapping.Cubicle;
import org.eclipse.persistence.testing.models.mapping.EmergencyExit;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.models.mapping.Employee1;
import org.eclipse.persistence.testing.models.mapping.Employee2;
import org.eclipse.persistence.testing.models.mapping.Hardware;
import org.eclipse.persistence.testing.models.mapping.Identification;
import org.eclipse.persistence.testing.models.mapping.Joystick;
import org.eclipse.persistence.testing.models.mapping.Keyboard;
import org.eclipse.persistence.testing.models.mapping.KeyboardProject;
import org.eclipse.persistence.testing.models.mapping.KeyboardTables;
import org.eclipse.persistence.testing.models.mapping.LegacyTableMaker;
import org.eclipse.persistence.testing.models.mapping.LegacyTestProject;
import org.eclipse.persistence.testing.models.mapping.MappingProject;
import org.eclipse.persistence.testing.models.mapping.Monitor;
import org.eclipse.persistence.testing.models.mapping.MultipleTableTestProject;
import org.eclipse.persistence.testing.models.mapping.MultipleTableTestTableMaker;
import org.eclipse.persistence.testing.models.mapping.Peripheral;
import org.eclipse.persistence.testing.models.mapping.Phone;
import org.eclipse.persistence.testing.models.mapping.SecureSystem;
import org.eclipse.persistence.testing.models.mapping.Shipment;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class MappingSystem
extends TestSystem {
    protected static boolean useFastTableCreatorAfterInitialCreate = Boolean.getBoolean("eclipselink.test.toggle-fast-table-creator");
    protected static boolean isFirstCreation = true;
    protected Project legacyProject;
    protected Project multipleTableProject;
    protected Project keyboardProject;
    protected Project bidirectionalProject;

    public MappingSystem() {
        this.project = new MappingProject();
        this.legacyProject = new LegacyTestProject();
        this.multipleTableProject = new MultipleTableTestProject();
        this.keyboardProject = new KeyboardProject();
        this.bidirectionalProject = new BiDirectionInserOrderTestProject();
    }

    public void addDescriptors(DatabaseSession session) {
        DatabasePlatform platform = session.getLogin().getPlatform();
        ClassDescriptor empDescriptor = (ClassDescriptor)this.project.getDescriptors().get(Employee.class);
        Employee.addToDescriptor(empDescriptor);
        ClassDescriptor hardwareDescriptor = (ClassDescriptor)this.project.getDescriptors().get(Hardware.class);
        Hardware.addToDescriptor(hardwareDescriptor);
        ClassDescriptor monitorDescriptor = (ClassDescriptor)this.project.getDescriptors().get(Monitor.class);
        Monitor.addToDescriptor(monitorDescriptor);
        if (platform.isAccess()) {
            empDescriptor.getMappings().removeElement(empDescriptor.getMappingForAttributeName("jobDescription"));
        }
        if (platform.getDefaultSequence().shouldAcquireValueAfterInsert()) {
            RelationalDescriptor cubicleDescriptor = (RelationalDescriptor)this.project.getDescriptors().get(Cubicle.class);
            cubicleDescriptor.setSequenceNumberField(null);
            cubicleDescriptor.setSequenceNumberName(null);
        }
        session.addDescriptors(this.project);
        session.addDescriptors(this.legacyProject);
        session.addDescriptors(this.multipleTableProject);
        session.addDescriptors(this.keyboardProject);
        ClassDescriptor joystickDescriptor = (ClassDescriptor)this.keyboardProject.getDescriptors().get(Joystick.class);
        joystickDescriptor.addConstraintDependencies(Keyboard.class);
        session.addDescriptors(this.bidirectionalProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables(DatabaseSession session) {
        SchemaManager schemaManager = new SchemaManager(session);
        boolean orig_FAST_TABLE_CREATOR = SchemaManager.FAST_TABLE_CREATOR;
        if (useFastTableCreatorAfterInitialCreate && !isFirstCreation) {
            SchemaManager.FAST_TABLE_CREATOR = true;
        }
        new LegacyTableMaker().replaceTables(session);
        new MultipleTableTestTableMaker().replaceTables(session);
        new KeyboardTables().replaceTables(session);
        new BiDirectionInsertOrderTableMaker().replaceTables(session);
        TableDefinition empDefinition = Employee.tableDefinition();
        DatabasePlatform platform = session.getLogin().getPlatform();
        if (!platform.isAccess()) {
            empDefinition.addField("JDESC", Byte[].class);
        }
        try {
            schemaManager.replaceObject((DatabaseObjectDefinition)empDefinition);
            schemaManager.replaceObject((DatabaseObjectDefinition)Employee.joinTableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)Employee.employeePhoneJoinTableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)Phone.tableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)CompanyCard.tableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)Computer.tableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)Cubicle.tableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)EmergencyExit.tableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)EmergencyExit.relationTableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)Shipment.tableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)MappingSystem.getPolicyTableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)Address.tableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)Monitor.tableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)Hardware.tableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)Peripheral.tableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)SecureSystem.tableDefinition());
            schemaManager.replaceObject((DatabaseObjectDefinition)Identification.tableDefinition());
            schemaManager.createSequences();
        }
        finally {
            if (useFastTableCreatorAfterInitialCreate && !isFirstCreation) {
                SchemaManager.FAST_TABLE_CREATOR = orig_FAST_TABLE_CREATOR;
            }
        }
        isFirstCreation = false;
    }

    public static TableDefinition getPolicyTableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("MAP_POL");
        definition.addField("FNAME", String.class, 20);
        definition.addField("LNAME", String.class, 20);
        definition.addField("POLICY", String.class, 20);
        return definition;
    }

    public void populate(DatabaseSession session) {
        PopulationManager manager = PopulationManager.getDefaultManager();
        UnitOfWork unitOfWork = session.acquireUnitOfWork();
        Employee1 employee_1 = Employee1.example1();
        Employee1 employee_2 = Employee1.example2();
        Employee1 employee_3 = Employee1.example3();
        unitOfWork.registerObject((Object)employee_1);
        manager.registerObject((Object)employee_1, "example1");
        manager.registerObject((Object)employee_2, "example2");
        unitOfWork.registerObject((Object)employee_3);
        manager.registerObject((Object)employee_3, "example3");
        Employee2 employee2_1 = Employee2.example1();
        Employee2 employee2_2 = Employee2.example2();
        unitOfWork.registerObject((Object)employee2_1);
        manager.registerObject((Object)employee2_1, "example1");
        manager.registerObject((Object)employee2_2, "example2");
        Employee employee1 = Employee.example1();
        Employee employee2 = Employee.example2();
        Employee employee3 = Employee.example3();
        Employee employee4 = Employee.example4();
        Employee employee5 = Employee.example5();
        Employee employee6 = Employee.example6();
        ClassDescriptor cubicleDescriptor = session.getClassDescriptor(Cubicle.class);
        if (!cubicleDescriptor.usesSequenceNumbers()) {
            Employee[] employees = new Employee[]{employee1, employee2, employee3, employee4, employee5, employee6};
            int id = 100;
            for (int i = 0; i < employees.length; ++i) {
                if (employees[i].cubicle == null || employees[i].cubicle.id != null) continue;
                employees[i].cubicle.id = new BigDecimal(id);
                id += 10;
            }
        }
        employee1.setManager(null);
        employee1.addManagedEmployee(employee2);
        employee1.addManagedEmployee(employee3);
        employee2.setManager(employee1);
        employee2.addManagedEmployee(employee4);
        employee3.setManager(employee1);
        employee3.addManagedEmployee(employee5);
        employee4.setManager(employee2);
        employee5.setManager(employee3);
        employee5.addManagedEmployee(employee6);
        employee6.setManager(employee5);
        unitOfWork.registerObject((Object)employee1);
        manager.registerObject((Object)employee1, "example1");
        manager.registerObject((Object)employee1.computer, "example1");
        manager.registerObject(employee1.shipments.firstElement(), "example1");
        unitOfWork.registerObject((Object)employee2);
        manager.registerObject((Object)employee2, "example2");
        manager.registerObject((Object)employee2.computer, "example2");
        manager.registerObject(employee2.shipments.firstElement(), "example2");
        unitOfWork.registerObject((Object)employee3);
        manager.registerObject((Object)employee3, "example3");
        manager.registerObject((Object)employee3.computer, "example3");
        unitOfWork.registerObject((Object)employee4);
        manager.registerObject((Object)employee4, "example4");
        manager.registerObject((Object)employee4.computer, "example4");
        manager.registerObject(employee4.shipments.firstElement(), "example4");
        unitOfWork.registerObject((Object)employee5);
        manager.registerObject((Object)employee5, "example5");
        manager.registerObject((Object)employee5.computer, "example5");
        manager.registerObject(employee5.shipments.firstElement(), "example5");
        unitOfWork.registerObject((Object)employee6);
        manager.registerObject((Object)employee6, "example6");
        manager.registerObject((Object)employee6.computer, "example6");
        Address address1 = Address.example1();
        Address address2 = Address.example2();
        manager.registerObject((Object)address1, "example1");
        manager.registerObject((Object)address2, "example2");
        unitOfWork.registerObject((Object)address1);
        unitOfWork.registerObject((Object)address2);
        unitOfWork.commit();
    }

    public static void modifyOneToOneMappingDescriptor(ClassDescriptor descriptor) {
        OneToOneMapping oneToOneMapping = (OneToOneMapping)descriptor.getMappingForAttributeName("cubicle");
        Expression exp = oneToOneMapping.buildSelectionCriteria();
        ExpressionBuilder builder = exp.getBuilder();
        Expression addedExpression = builder.getField("MAP_CUB.LOCATION").equal((Object)"3rd floor, Section R, Third qubicle on left");
        oneToOneMapping.setSelectionCriteria(exp.and(addedExpression));
    }

    public static void modifyOneToManyMappingDescriptor(ClassDescriptor descriptor) {
        OneToManyMapping oneToManyMapping = (OneToManyMapping)descriptor.getMappingForAttributeName("managedEmployees");
        Expression exp = oneToManyMapping.buildSelectionCriteria();
        ExpressionBuilder builder = exp.getBuilder();
        Expression addedExpression = builder.getField("MAP_EMP.LNAME").equal((Object)"Chapman");
        oneToManyMapping.setSelectionCriteria(exp.and(addedExpression));
    }

    public static void modifyTargetOneToOneMappingDescriptor(ClassDescriptor descriptor) {
        OneToOneMapping oneToOneMapping = (OneToOneMapping)descriptor.getMappingForAttributeName("computer");
        Expression exp = oneToOneMapping.buildSelectionCriteria();
        ExpressionBuilder builder = exp.getBuilder();
        Expression addedExpression = builder.getField("MAP_HRW.EMP_LNAME").equal((Object)"Louis");
        oneToOneMapping.setSelectionCriteria(exp.and(addedExpression));
    }
}

