/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.io;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.io.StringBuilderWriter;
import org.eclipse.persistence.tools.utility.tests.TestTools;

@SuppressWarnings("nls")
public class StringBuilderWriterTests
	extends TestCase
{
	private StringBuilderWriter writer;


	public StringBuilderWriterTests(String name) {
		super(name);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		this.writer = new StringBuilderWriter();
	}

	@Override
	protected void tearDown() throws Exception {
		TestTools.clear(this);
		super.tearDown();
	}

	public void testWriteInt() throws Exception {
		this.writer.write('a');
		this.writer.write('b');
		this.writer.write('c');
		assertEquals(3, this.writer.getBuilder().length());
		assertEquals("abc", this.writer.toString());
	}

	public void testWriteCharArray() throws Exception {
		this.writer.write(new char[] {'a', 'b', 'c'});
		this.writer.write(new char[] {'a', 'b', 'c'});
		assertEquals(6, this.writer.getBuilder().length());
		assertEquals("abcabc", this.writer.toString());
	}

	public void testWriteString() throws Exception {
		this.writer.write("abc");
		this.writer.write("abc");
		assertEquals(6, this.writer.getBuilder().length());
		assertEquals("abcabc", this.writer.toString());
	}

	public void testWriteStringIntInt() throws Exception {
		this.writer.write("abc", 1, 2);
		this.writer.write("abc", 2, 1);
		assertEquals(3, this.writer.getBuilder().length());
		assertEquals("bcc", this.writer.toString());
	}
}