/*******************************************************************************
 * Copyright (c) 2008, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.command;

/**
 * Wrap a {@link Runnable} so it can be used as a {@link Command}.
 */
@SuppressWarnings("nls")
public class RunnableCommand
	implements Command
{
	protected final Runnable runnable;

	public RunnableCommand(Runnable runnable) {
		super();
		if (runnable == null) {
			throw new NullPointerException();
		}
		this.runnable = runnable;
	}

	@Override
	public void execute() {
		this.runnable.run();
	}

	@Override
	public String toString() {
		return "Command[" + this.runnable +']';
	}
}