/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.persistence;

import java.io.IOException;
import java.net.URL;
import org.eclipse.persistence.tools.mapping.orm.ExternalForm;

/**
 * Interface defining access to metadata from the persistence.xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 */
public interface ExternalPersistenceRepository extends ExternalForm {

	/**
	 * Creates a Persistence Configuration in the given location and returns the external form.
	 *
	 * @param location The location where to create the file
	 * @param type The JPA document type
	 * @return The external form of the newly created Persistence Configuration
	 */
	ExternalPersistenceConfiguration buildPersistenceConfiguration(URL location, PersistenceDocumentType type) throws IOException;

	/**
	 * Returns the persistence configuration specified at the given location.
	 *
	 * @param location The location of the Persistence Configuration to retrieve
	 * @return The external form of the Persistence Configuration or <code>null</code> if none is at
	 * the given location
	 */
	ExternalPersistenceConfiguration getPersistenceConfiguration(String persistenceXML);
}