/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.DiscriminatorType;

/**
 * This interface and inherited behavior describes the configurable properties for an tenant
 * discriminator column. One or more columns can be declared on a Multitenant
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.TenantDiscriminatorColumn
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalTenantDiscriminatorColumn extends ExternalForm {

	/**
	 * Returns the SQL definition of the column.
	 */
	String getColumnDefinition();

	/**
	 * Returns the context property of the column.
	 */
	String getContextProperty();

	/**
	 * Type of the discriminator column.
	 */
	DiscriminatorType getDiscriminatorType();

	/**
	 * Index of this discriminator column.
	 */
	int getIndex();

	/**
	 * Returns the length of the column.
	 */
	Integer getLength();

	/**
	 * Name of the discriminator column.
	 */
	String getName();

	/**
	 * Returns whether this column is part of the primary key
	 */
	Boolean isPrimaryKey();

	/**
	 * Returns the table name that this column exists in
	 */
	String getTableName();

	/**
	 * Set the column definition
	 */
	void setColumnDefinition(String definition);

	/**
	 * Set the context property for the column
	 */
	void setContextProperty(String contextProperty);

	/**
	 * Set the discriminator type
	 */
	void setDiscriminatorType(DiscriminatorType type);

	/**
	 * Set the index
	 */
	void setIndex(int index);

	/**
	 * Set the length
	 */
	void setLength(Integer length);

	/**
	 * Sets the name of the column
	 */
	void setName(String name);

	/**
	 * Sets whether this column is part of the primary key
	 */
	void setIsPrimaryKey(Boolean primaryKey);

	/**
	 * Sets the table name in which this column exists
	 */
	void setTableName(String tableName);
}
