/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * This interface represents the basis for an discriminator class defined by the EclipseLink JPA
 * spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalDiscriminatorClass extends ExternalForm {

	/**
	 * Returns the discriminator string.
	 */
	String getDiscriminator();

	/**
	 * Returns the position of this discriminator class within the list of discriminator classes
	 * owned by the parent.
	 *
	 * @return The position of this external form in the list of the same type
	 */
	int getIndex();

	/**
	 * Returns the discriminator value.
	 */
	String getValue();

	/**
	 * Set the discriminator string
	 */
	void setDiscriminator(String discriminator);

	/**
	 * Set the discriminator value
	 */
	void setValue(String value);
}