/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.listener;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.event.StateChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.ReflectiveChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.StateChangeListener;

public class ReflectiveStateChangeListenerTests
extends TestCase {
    public ReflectiveStateChangeListenerTests(String name) {
        super(name);
    }

    public void testZeroArgument() {
        TestModel testModel = new TestModel();
        Target target = new Target(testModel);
        testModel.addStateChangeListener(ReflectiveChangeListener.buildStateChangeListener((Object)target, (String)"stateChangedZeroArgument"));
        testModel.changeState();
        ReflectiveStateChangeListenerTests.assertTrue((boolean)target.zeroArgumentFlag);
        ReflectiveStateChangeListenerTests.assertFalse((boolean)target.singleArgumentFlag);
    }

    public void testSingleArgument() {
        TestModel testModel = new TestModel();
        Target target = new Target(testModel);
        testModel.addStateChangeListener(ReflectiveChangeListener.buildStateChangeListener((Object)target, (String)"stateChangedSingleArgument"));
        testModel.changeState();
        ReflectiveStateChangeListenerTests.assertFalse((boolean)target.zeroArgumentFlag);
        ReflectiveStateChangeListenerTests.assertTrue((boolean)target.singleArgumentFlag);
    }

    public void testSingleArgument2() throws Exception {
        TestModel testModel = new TestModel();
        Target target = new Target(testModel);
        Method method = ObjectTools.method((Object)target, (String)"stateChangedSingleArgument2", (Class[])new Class[]{Object.class});
        testModel.addStateChangeListener(ReflectiveChangeListener.buildStateChangeListener((Object)target, (Method)method));
        testModel.changeState();
        ReflectiveStateChangeListenerTests.assertFalse((boolean)target.zeroArgumentFlag);
        ReflectiveStateChangeListenerTests.assertTrue((boolean)target.singleArgumentFlag);
    }

    public void testListenerMismatch() {
        TestModel testModel = new TestModel();
        Target target = new Target(testModel);
        StateChangeListener listener = ReflectiveChangeListener.buildStateChangeListener((Object)target, (String)"stateChangedSingleArgument");
        testModel.addPropertyChangeListener("value", (PropertyChangeListener)listener);
        boolean exCaught = false;
        try {
            testModel.changeProperty();
            ReflectiveStateChangeListenerTests.fail((String)("listener mismatch: " + listener));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ReflectiveStateChangeListenerTests.assertTrue((boolean)exCaught);
    }

    public void testBogusDoubleArgument1() {
        boolean exCaught;
        block2: {
            TestModel testModel = new TestModel();
            Target target = new Target(testModel);
            exCaught = false;
            try {
                StateChangeListener listener = ReflectiveChangeListener.buildStateChangeListener((Object)target, (String)"stateChangedDoubleArgument");
                ReflectiveStateChangeListenerTests.fail((String)("bogus listener: " + listener));
            }
            catch (RuntimeException ex) {
                if (ex.getCause().getClass() != NoSuchMethodException.class) break block2;
                exCaught = true;
            }
        }
        ReflectiveStateChangeListenerTests.assertTrue((boolean)exCaught);
    }

    public void testBogusDoubleArgument2() throws Exception {
        boolean exCaught;
        block2: {
            TestModel testModel = new TestModel();
            Target target = new Target(testModel);
            Method method = ObjectTools.method((Object)target, (String)"stateChangedDoubleArgument", (Class[])new Class[]{StateChangeEvent.class, Object.class});
            exCaught = false;
            try {
                StateChangeListener listener = ReflectiveChangeListener.buildStateChangeListener((Object)target, (Method)method);
                ReflectiveStateChangeListenerTests.fail((String)("bogus listener: " + listener));
            }
            catch (RuntimeException ex) {
                if (!ex.getMessage().equals(method.toString())) break block2;
                exCaught = true;
            }
        }
        ReflectiveStateChangeListenerTests.assertTrue((boolean)exCaught);
    }

    class Target {
        TestModel testModel;
        boolean zeroArgumentFlag = false;
        boolean singleArgumentFlag = false;

        Target(TestModel testModel) {
            this.testModel = testModel;
        }

        void stateChangedZeroArgument() {
            this.zeroArgumentFlag = true;
        }

        void stateChangedSingleArgument(StateChangeEvent e) {
            this.singleArgumentFlag = true;
            ReflectiveStateChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
        }

        void stateChangedSingleArgument2(Object e) {
            this.singleArgumentFlag = true;
            ReflectiveStateChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)((StateChangeEvent)e).getSource());
        }

        void stateChangedDoubleArgument(StateChangeEvent e, Object o) {
            ReflectiveStateChangeListenerTests.fail((String)("bogus event: " + e + " - object: " + o));
        }
    }

    class TestModel
    extends AbstractModel {
        TestModel() {
        }

        void changeState() {
            this.fireStateChanged();
        }

        void changeProperty() {
            this.firePropertyChanged("value", 55, 42);
        }
    }
}

