/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.iterable;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterable.ChainIterable;
import org.eclipse.persistence.tools.utility.iterator.ChainIterator;

public class ChainIterableTests
extends TestCase {
    private static final Class<?>[] VECTOR_HIERARCHY = new Class[]{Vector.class, AbstractList.class, AbstractCollection.class, Object.class};

    public ChainIterableTests(String name) {
        super(name);
    }

    public void testNextLink() {
        int i = 0;
        for (Class<?> clazz : this.buildIterable()) {
            ChainIterableTests.assertEquals(VECTOR_HIERARCHY[i++], clazz);
        }
    }

    public void testLinker() {
        int i = 0;
        for (Class clazz : new ChainIterable(Vector.class, this.buildLinker())) {
            ChainIterableTests.assertEquals(VECTOR_HIERARCHY[i++], (Object)clazz);
        }
    }

    public void testException() {
        ChainIterable iterable = new ChainIterable(Vector.class);
        Iterator iterator = iterable.iterator();
        boolean exCaught = false;
        try {
            Class clazz = (Class)iterator.next();
            ChainIterableTests.fail((String)("bogus class: " + clazz));
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        ChainIterableTests.assertTrue((boolean)exCaught);
    }

    public void testToString() {
        ChainIterableTests.assertNotNull((Object)this.buildIterable().toString());
    }

    private Iterable<Class<?>> buildIterable() {
        return this.buildChainIterable(Vector.class);
    }

    private Iterable<Class<?>> buildChainIterable(Class<?> startLink) {
        return new ChainIterable<Class<?>>(startLink){

            protected Class<?> nextLink(Class<?> currentLink) {
                return currentLink.getSuperclass();
            }
        };
    }

    private ChainIterator.Linker<Class<?>> buildLinker() {
        return new ChainIterator.Linker<Class<?>>(){

            public Class<?> nextLink(Class<?> currentLink) {
                return currentLink.getSuperclass();
            }
        };
    }
}

