/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.command;

import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.command.CommandExecutor;
import org.eclipse.persistence.tools.utility.command.StatefulCommandExecutor;
import org.eclipse.persistence.tools.utility.reference.SynchronizedBoolean;

public abstract class AbstractStatefulCommandExecutor<E extends CommandExecutor>
implements StatefulCommandExecutor {
    protected final SynchronizedBoolean active = new SynchronizedBoolean(false);
    protected final E commandExecutor;

    protected AbstractStatefulCommandExecutor(E commandExecutor) {
        if (commandExecutor == null) {
            throw new NullPointerException();
        }
        this.commandExecutor = commandExecutor;
    }

    @Override
    public synchronized void start() {
        if (this.active.isTrue()) {
            throw new IllegalStateException("Not stopped.");
        }
        this.active.setTrue();
    }

    @Override
    public void execute(Command command) {
        if (this.active.isTrue()) {
            this.commandExecutor.execute(command);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.active.isFalse()) {
            throw new IllegalStateException("Not started.");
        }
        this.active.setFalse();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.commandExecutor);
    }
}

