/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalUniqueConstraint;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.UniqueConstraint;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

abstract class Table
extends AbstractExternalForm
implements ExternalEntityTable {
    static final String CATALOG = "catalog";
    static final String NAME = "name";
    static final String SCHEMA = "schema";

    Table(AbstractExternalForm parent) {
        super(parent);
    }

    @Override
    public final void addUniqueConstraint(int index, ListIterator<String> columnNames) {
        UniqueConstraint uniqueConstraint = this.buildUniqueConstraint(index);
        uniqueConstraint.addSelf();
        uniqueConstraint.setColumnNames(columnNames);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(NAME);
        names.add(CATALOG);
        names.add(SCHEMA);
        return names;
    }

    private UniqueConstraint buildUniqueConstraint(int index) {
        return new UniqueConstraint(this, index);
    }

    @Override
    public final String getCatalogName() {
        return this.getAttribute(CATALOG);
    }

    @Override
    public final String getName() {
        return this.getAttribute(NAME);
    }

    @Override
    public final String getSchemaName() {
        return this.getAttribute(SCHEMA);
    }

    @Override
    public final ExternalUniqueConstraint getUniqueConstraint(int index) {
        Element element = this.getChild("unique-constraint", index);
        if (element == null) {
            return null;
        }
        return this.buildUniqueConstraint(index);
    }

    @Override
    public final void removeAllUniqueConstraints() {
        this.removeChildren("unique-constraint");
    }

    @Override
    public final void removeUniqueConstraint(int index) {
        UniqueConstraint uniqueConstraint = this.buildUniqueConstraint(index);
        uniqueConstraint.removeSelf();
    }

    @Override
    public final void setCatalogName(String catalog) {
        this.setAttribute(CATALOG, catalog);
    }

    @Override
    public final void setName(String name) {
        this.setAttribute(NAME, name);
    }

    @Override
    public final void setSchemaName(String name) {
        this.setAttribute(SCHEMA, name);
    }

    @Override
    public final ListIterable<ExternalUniqueConstraint> uniqueConstraints() {
        int count = this.uniqueConstraintsSize();
        ArrayList<UniqueConstraint> uniqueConstraints = new ArrayList<UniqueConstraint>(count);
        int index = count;
        while (--index >= 0) {
            UniqueConstraint uniqueConstraint = this.buildUniqueConstraint(index);
            uniqueConstraints.add(0, uniqueConstraint);
        }
        return new ListListIterable(uniqueConstraints);
    }

    @Override
    public final int uniqueConstraintsSize() {
        return this.getChildrenSize("unique-constraint");
    }
}

