/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityListener;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperClassEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.PersistenceUnit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class EntityListener
extends AbstractExternalForm
implements ExternalEntityListener {
    private boolean entity;
    private int index;
    static String CLASS = "class";
    static String DESCRIPTION = "description";
    static String ENTITY_LISTENER = "entity-listener";
    static String ENTITY_LISTENERS = "entity-listeners";
    static String METHOD_NAME = "method-name";
    static String POST_LOAD = "post-load";
    static String POST_PERSIST = "post-persist";
    static String POST_REMOVE = "post-remove";
    static String POST_UPDATE = "post-update";
    static String PRE_PERSIST = "pre-persist";
    static String PRE_REMOVE = "pre-remove";
    static String PRE_UPDATE = "pre-update";

    EntityListener(MappedSuperClassEntity parent, int index) {
        super(parent);
        this.index = index;
        this.entity = true;
    }

    EntityListener(PersistenceUnit parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    protected Element addSelf(String elementName, List<String> elementNamesOrder) {
        Element parentElement;
        if (this.entity) {
            parentElement = this.getParentElement();
        } else {
            parentElement = this.getChild(this.getParent(), "persistence-unit-defaults");
            if (parentElement == null) {
                parentElement = this.addChild(this.getParent(), "persistence-unit-defaults", elementNamesOrder);
            }
        }
        Element element = this.getChild((Node)parentElement, ENTITY_LISTENERS);
        if (element == null) {
            element = this.addChild(parentElement, ENTITY_LISTENERS, this.index);
        }
        return this.addChild(element, ENTITY_LISTENER);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DESCRIPTION);
        names.add(PRE_PERSIST);
        names.add(POST_PERSIST);
        names.add(PRE_REMOVE);
        names.add(POST_REMOVE);
        names.add(PRE_UPDATE);
        names.add(POST_UPDATE);
        names.add(POST_LOAD);
        return names;
    }

    @Override
    public String getClassName() {
        return this.getAttribute(CLASS);
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode(DESCRIPTION);
    }

    @Override
    public Element getElement() {
        Element parentElement = this.entity ? this.getParentElement() : this.getChild(this.getParent(), "persistence-unit-defaults");
        if (parentElement == null) {
            return null;
        }
        Element element = this.getChild((Node)parentElement, ENTITY_LISTENERS);
        if (element == null) {
            return null;
        }
        return this.getChild(element, ENTITY_LISTENER, this.index);
    }

    @Override
    protected String getElementName() {
        return ENTITY_LISTENER;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getPostLoadMethod() {
        return this.getChildAttribute(POST_LOAD, METHOD_NAME);
    }

    @Override
    public String getPostLoadMethodDescription() {
        return this.getChildAttribute(POST_LOAD, DESCRIPTION);
    }

    @Override
    public String getPostPersistMethod() {
        return this.getChildAttribute(POST_PERSIST, METHOD_NAME);
    }

    @Override
    public String getPostPersistMethodDescription() {
        return this.getChildAttribute(POST_PERSIST, DESCRIPTION);
    }

    @Override
    public String getPostRemoveMethod() {
        return this.getChildAttribute(POST_REMOVE, METHOD_NAME);
    }

    @Override
    public String getPostRemoveMethodDescription() {
        return this.getChildAttribute(POST_REMOVE, DESCRIPTION);
    }

    @Override
    public String getPostUpdateMethod() {
        return this.getChildAttribute(POST_UPDATE, METHOD_NAME);
    }

    @Override
    public String getPostUpdateMethodDescription() {
        return this.getChildAttribute(POST_UPDATE, DESCRIPTION);
    }

    @Override
    public String getPrePersistMethod() {
        return this.getChildAttribute(PRE_PERSIST, METHOD_NAME);
    }

    @Override
    public String getPrePersistMethodDescription() {
        return this.getChildAttribute(PRE_PERSIST, DESCRIPTION);
    }

    @Override
    public String getPreRemoveMethod() {
        return this.getChildAttribute(PRE_REMOVE, METHOD_NAME);
    }

    @Override
    public String getPreRemoveMethodDescription() {
        return this.getChildAttribute(PRE_REMOVE, DESCRIPTION);
    }

    @Override
    public String getPreUpdateMethod() {
        return this.getChildAttribute(PRE_UPDATE, METHOD_NAME);
    }

    @Override
    public String getPreUpdateMethodDescription() {
        return this.getChildAttribute(PRE_UPDATE, DESCRIPTION);
    }

    @Override
    public void removeSelf() {
        Element parentElement;
        Element element = parentElement = this.entity ? this.getParentElement() : this.getChild(this.getParent(), "persistence-unit-defaults");
        if (parentElement == null) {
            return;
        }
        Element element2 = this.getChild((Node)parentElement, ENTITY_LISTENERS);
        if (element2 != null) {
            this.removeChild(element2, ENTITY_LISTENER, this.index);
            if (!this.hasAnyChildren(element2)) {
                this.remove(parentElement, element2);
            }
        }
    }

    @Override
    public void setClassName(String name) {
        this.setAttribute(CLASS, name);
    }

    @Override
    public void setDescription(String description) {
        this.updateChildTextNode(DESCRIPTION, description);
    }

    @Override
    public void setPostLoadMethod(String value) {
        this.updateChildAttribute(POST_LOAD, METHOD_NAME, value);
    }

    @Override
    public void setPostLoadMethodDescription(String name) {
        this.updateChildChildTextNode(POST_LOAD, DESCRIPTION, name);
    }

    @Override
    public void setPostPersistMethod(String value) {
        this.updateChildAttribute(POST_PERSIST, METHOD_NAME, value);
    }

    @Override
    public void setPostPersistMethodDescription(String name) {
        this.updateChildChildTextNode(POST_PERSIST, DESCRIPTION, name);
    }

    @Override
    public void setPostRemoveMethod(String value) {
        this.updateChildAttribute(POST_REMOVE, METHOD_NAME, value);
    }

    @Override
    public void setPostRemoveMethodDescription(String name) {
        this.updateChildChildTextNode(POST_REMOVE, DESCRIPTION, name);
    }

    @Override
    public void setPostUpdateMethod(String value) {
        this.updateChildAttribute(POST_UPDATE, METHOD_NAME, value);
    }

    @Override
    public void setPostUpdateMethodDescription(String name) {
        this.updateChildChildTextNode(POST_UPDATE, DESCRIPTION, name);
    }

    @Override
    public void setPrePersistMethod(String value) {
        this.updateChildAttribute(PRE_PERSIST, METHOD_NAME, value);
    }

    @Override
    public void setPrePersistMethodDescription(String name) {
        this.updateChildChildTextNode(PRE_PERSIST, DESCRIPTION, name);
    }

    @Override
    public void setPreRemoveMethod(String value) {
        this.updateChildAttribute(PRE_REMOVE, METHOD_NAME, value);
    }

    @Override
    public void setPreRemoveMethodDescription(String name) {
        this.updateChildChildTextNode(PRE_REMOVE, DESCRIPTION, name);
    }

    @Override
    public void setPreUpdateMethod(String value) {
        this.updateChildAttribute(PRE_UPDATE, METHOD_NAME, value);
    }

    @Override
    public void setPreUpdateMethodDescription(String name) {
        this.updateChildChildTextNode(PRE_UPDATE, DESCRIPTION, name);
    }
}

