/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTest;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestResult;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestExecutor;
import org.eclipse.persistence.testing.tests.performance.emulateddb.EmulatedDriver;

public abstract class PerformanceComparisonTestCase
extends TestCase
implements PerformanceComparisonTest {
    public double allowableDecrease = -5.0;
    public long testRunTime = 10000L;
    protected List tests = new ArrayList();
    protected volatile int iterations;

    @Override
    public int getIterations() {
        return this.iterations;
    }

    @Override
    public void incrementIterations() {
        ++this.iterations;
    }

    @Override
    public void resetIterations() {
        this.iterations = 0;
    }

    @Override
    public void startTest() {
    }

    @Override
    public void endTest() {
    }

    @Override
    public long getTestRunTime() {
        return this.testRunTime;
    }

    @Override
    public void setTestRunTime(long testRunTime) {
        this.testRunTime = testRunTime;
    }

    @Override
    public double getAllowableDecrease() {
        return this.allowableDecrease;
    }

    @Override
    public void setAllowableDecrease(double allowableDecrease) {
        this.allowableDecrease = allowableDecrease;
    }

    @Override
    public List getTests() {
        return this.tests;
    }

    @Override
    public void addTest(TestCase test) {
        this.getTests().add(test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TestExecutor executor) {
        System.out.println("Begin:" + this.getName());
        try {
            super.execute(executor);
        }
        finally {
            System.out.println("End:" + this.getName() + ":" + this.getTestResult().getTotalTime());
        }
    }

    @Override
    public void executeTest() throws Throwable {
        PerformanceComparisonTestCase.executeTest(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeTest(PerformanceComparisonTest performanceTest) throws Throwable {
        PerformanceComparisonTestResult result = new PerformanceComparisonTestResult((TestCase)((Object)performanceTest), "Passed");
        ((TestCase)((Object)performanceTest)).setTestResult(result);
        try {
            for (int index = 0; index < 5; ++index) {
                long endTime;
                long startTime;
                int iterations = 0;
                try {
                    System.gc();
                    Thread.sleep(1000L);
                    performanceTest.resetIterations();
                    startTime = System.currentTimeMillis();
                    performanceTest.startTest();
                    endTime = startTime;
                    while (startTime + performanceTest.getTestRunTime() >= endTime) {
                        ((TestCase)((Object)performanceTest)).test();
                        performanceTest.incrementIterations();
                        endTime = System.currentTimeMillis();
                    }
                    iterations = performanceTest.getIterations();
                }
                finally {
                    performanceTest.endTest();
                }
                result.addTestCount(iterations, 0);
                for (int testIndex = 0; testIndex < performanceTest.getTests().size(); ++testIndex) {
                    PerformanceComparisonTest test = (PerformanceComparisonTest)performanceTest.getTests().get(testIndex);
                    ((TestCase)((Object)test)).setExecutor(((TestCase)((Object)performanceTest)).getExecutor());
                    try {
                        System.gc();
                        Thread.sleep(1000L);
                        performanceTest.resetIterations();
                        startTime = System.currentTimeMillis();
                        test.startTest();
                        endTime = startTime;
                        while (startTime + performanceTest.getTestRunTime() >= endTime) {
                            ((TestCase)((Object)test)).test();
                            performanceTest.incrementIterations();
                            endTime = System.currentTimeMillis();
                        }
                        iterations = performanceTest.getIterations();
                    }
                    finally {
                        test.endTest();
                    }
                    result.addTestCount(iterations, testIndex + 1);
                }
            }
        }
        finally {
            result.computeResults();
        }
    }

    @Override
    public void verify() {
        PerformanceComparisonTestCase.verify(this);
    }

    public static void verify(PerformanceComparisonTest performanceTest) {
        PerformanceComparisonTestResult result = (PerformanceComparisonTestResult)((TestCase)((Object)performanceTest)).getTestResult();
        for (int index = 0; index < result.percentageDifferences.size(); ++index) {
            PerformanceComparisonTest test;
            double allowable;
            double difference = ((Number)result.percentageDifferences.get(index)).doubleValue();
            if (!(difference < (allowable = (test = (PerformanceComparisonTest)performanceTest.getTests().get(index)).getAllowableDecrease()))) continue;
            throw new TestErrorException("Decrease lower than allowable detected, decrease: " + difference + " allowed: " + allowable + " test: " + test.getName());
        }
    }

    public Session buildEmulatedSession() {
        try {
            Class.forName(this.getSession().getLogin().getDriverClassName());
        }
        catch (Exception ignore) {
            // empty catch block
        }
        Project project = this.getSession().getProject().clone();
        DatabaseLogin login = (DatabaseLogin)project.getLogin().clone();
        try {
            Class.forName(login.getDriverClassName());
        }
        catch (Exception ignore) {
            // empty catch block
        }
        login.setDriverClass(EmulatedDriver.class);
        login.setConnectionString("emulate:" + login.getConnectionString());
        project.setLogin(login);
        DatabaseSession session = project.createDatabaseSession();
        session.setSessionLog(this.getSession().getSessionLog());
        session.login();
        return session;
    }
}

