/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import java.util.Vector;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.interfaces.Company;
import org.eclipse.persistence.testing.models.interfaces.Contact;
import org.eclipse.persistence.testing.models.interfaces.ContactHolder;
import org.eclipse.persistence.testing.models.interfaces.Employee;
import org.eclipse.persistence.testing.models.interfaces.Phone;

public class VariableOneToOneNonPrivatelyOwnedTest
extends TransactionalTestCase {
    public Contact contact;
    public ContactHolder origional;

    public void test() {
        Vector phones = this.getSession().readAllObjects(Phone.class);
        for (Phone phone : phones) {
            if (phone.getEmp() == null) continue;
            this.contact = phone;
            break;
        }
        this.origional = (ContactHolder)this.contact.getEmp().clone();
        ContactHolder holder = this.contact.getEmp();
        if (holder instanceof Employee) {
            ((Employee)holder).setName("Bobby Vallence");
        } else {
            ((Company)holder).setName("Nowhere Company");
        }
        this.getDatabaseSession().writeObject((Object)this.contact);
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.contact = (Contact)this.getSession().readObject((Object)this.contact);
        if (!this.compareObjects(this.contact.getEmp(), this.origional)) {
            throw new TestErrorException("Write Object wrote non privately owned data to the database");
        }
    }
}

