/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterator;

import java.util.Iterator;
import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * A <code>ReadOnlyIterator</code> wraps another {@link Iterator}
 * and removes support for {@link #remove()}.
 *
 * @param <E> the type of elements returned by the iterator
 *
 * @see org.eclipse.jpt.common.utility.internal.iterable.ReadOnlyIterable
 */
public class ReadOnlyIterator<E>
	implements Iterator<E>
{
	private final Iterator<? extends E> iterator;

	/**
	 * Construct an iterator on the specified collection that
	 * disallows removes.
	 */
	public ReadOnlyIterator(Iterable<? extends E> c) {
		this(c.iterator());
	}

	/**
	 * Construct an iterator with the specified nested iterator
	 * and disallow removes.
	 */
	public ReadOnlyIterator(Iterator<? extends E> iterator) {
		super();
		if (iterator == null) {
			throw new NullPointerException();
		}
		this.iterator = iterator;
	}

	@Override
	public boolean hasNext() {
		// delegate to the nested iterator
		return this.iterator.hasNext();
	}

	@Override
	public E next() {
		// delegate to the nested iterator
		return this.iterator.next();
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this, this.iterator);
	}
}